/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegment;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

public class LogicalKeyValueSegments
extends AbstractSegments<LogicalKeyValueSegment> {
    private final RocksDBMetricsRecorder metricsRecorder;
    private final RocksDBStore physicalStore;
    private final Map<Long, LogicalKeyValueSegment> reservedSegments = new HashMap<Long, LogicalKeyValueSegment>();

    LogicalKeyValueSegments(String name, String parentDir, long retentionPeriod, long segmentInterval, RocksDBMetricsRecorder metricsRecorder) {
        super(name, retentionPeriod, segmentInterval);
        this.metricsRecorder = metricsRecorder;
        this.physicalStore = new RocksDBStore(name, parentDir, metricsRecorder, false);
    }

    @Override
    public void setPosition(Position position) {
        this.physicalStore.position = position;
    }

    @Override
    public LogicalKeyValueSegment getOrCreateSegment(long segmentId, StateStoreContext context) {
        if (this.segments.containsKey(segmentId)) {
            return (LogicalKeyValueSegment)this.segments.get(segmentId);
        }
        if (segmentId < 0L) {
            throw new IllegalArgumentException("Negative segment IDs are reserved for reserved segments, and should be created through createReservedSegment() instead");
        }
        LogicalKeyValueSegment newSegment = new LogicalKeyValueSegment(segmentId, this.segmentName(segmentId), this.physicalStore);
        if (this.segments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("LogicalKeyValueSegment already exists. Possible concurrent access.");
        }
        return newSegment;
    }

    LogicalKeyValueSegment createReservedSegment(long segmentId, String segmentName) {
        if (segmentId >= 0L) {
            throw new IllegalArgumentException("segmentId for a reserved segment must be negative");
        }
        LogicalKeyValueSegment newSegment = new LogicalKeyValueSegment(segmentId, segmentName, this.physicalStore);
        if (this.reservedSegments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("LogicalKeyValueSegment already exists.");
        }
        return newSegment;
    }

    LogicalKeyValueSegment getReservedSegment(long segmentId) {
        return this.reservedSegments.get(segmentId);
    }

    @Override
    public void openExisting(StateStoreContext context, long streamTime) {
        this.metricsRecorder.init(ProcessorContextUtils.metricsImpl(context), context.taskId());
        this.physicalStore.openDB(context.appConfigs(), context.stateDir());
    }

    @Override
    public void cleanupExpiredSegments(long streamTime) {
        super.cleanupExpiredSegments(streamTime);
    }

    @Override
    public void flush() {
        this.physicalStore.flush();
    }

    @Override
    public void close() {
        super.close();
        for (LogicalKeyValueSegment segment : this.reservedSegments.values()) {
            segment.close();
        }
        this.reservedSegments.clear();
        this.physicalStore.close();
    }

    @Override
    public String segmentName(long segmentId) {
        if (segmentId < 0L) {
            throw new IllegalArgumentException("Negative segment IDs are reserved for reserved segments, which have custom names that should not be accessed from this method");
        }
        return super.segmentName(segmentId);
    }
}

