/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvValueDecorator;
import java.io.IOException;
import java.util.Objects;

public class CsvValueDecorators {
    public static final CsvValueDecorator OPTIONAL_BRACKETS_DECORATOR = new StringPrefixSuffixDecorator("[", "]", true);
    public static final CsvValueDecorator STRICT_BRACKETS_DECORATOR = new StringPrefixSuffixDecorator("[", "]", false);

    public static CsvValueDecorator optionalPrefixSuffixDecorator(String prefix, String suffix) {
        return new StringPrefixSuffixDecorator(prefix, suffix, true);
    }

    public static CsvValueDecorator requiredPrefixSuffixDecorator(String prefix, String suffix) {
        return new StringPrefixSuffixDecorator(prefix, suffix, false);
    }

    public static class StringPrefixSuffixDecorator
    implements CsvValueDecorator {
        protected final String _prefix;
        protected final String _suffix;
        protected final boolean _optional;

        public StringPrefixSuffixDecorator(String prefix, String suffix, boolean optional) {
            this._prefix = Objects.requireNonNull(prefix);
            this._suffix = Objects.requireNonNull(suffix);
            this._optional = optional;
        }

        @Override
        public String decorateValue(CsvGenerator gen, String plainValue) throws IOException {
            return new StringBuilder(plainValue.length() + this._prefix.length() + this._suffix.length()).append(this._prefix).append(plainValue).append(this._suffix).toString();
        }

        @Override
        public String undecorateValue(CsvParser parser, String decoratedValue) throws IOException {
            int end;
            if (!decoratedValue.startsWith(this._prefix)) {
                if (!this._optional) {
                    parser._reportParsingError(String.format("Decorated value of column '%s' does not start with expected prefix (\"%s\"); value: \"%s\"", parser.currentName(), this._prefix, decoratedValue));
                }
                return decoratedValue;
            }
            if (!decoratedValue.endsWith(this._suffix)) {
                if (!this._optional) {
                    parser._reportParsingError(String.format("Decorated value of column '%s' does not end with expected suffix (\"%s\"); value: \"%s\"", parser.currentName(), this._suffix, decoratedValue));
                }
                return decoratedValue;
            }
            int start = this._prefix.length();
            if (start >= (end = decoratedValue.length() - this._suffix.length())) {
                return "";
            }
            return decoratedValue.substring(start, end);
        }
    }
}

