/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Operation;
import org.apache.juneau.bean.openapi3.Parameter;
import org.apache.juneau.bean.openapi3.Server;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class PathItem
extends OpenApiElement {
    private String summary;
    private String description;
    private Operation get;
    private Operation put;
    private Operation post;
    private Operation delete;
    private Operation options;
    private Operation head;
    private Operation patch;
    private Operation trace;
    private List<Server> servers;
    private List<Parameter> parameters;

    public PathItem() {
    }

    public PathItem(PathItem copyFrom) {
        super(copyFrom);
        this.summary = copyFrom.summary;
        this.description = copyFrom.description;
        this.get = copyFrom.get;
        this.put = copyFrom.put;
        this.post = copyFrom.post;
        this.delete = copyFrom.delete;
        this.options = copyFrom.options;
        this.head = copyFrom.head;
        this.patch = copyFrom.patch;
        this.trace = copyFrom.trace;
        this.servers = CollectionUtils.copyOf(copyFrom.servers);
        this.parameters = CollectionUtils.copyOf(copyFrom.parameters);
    }

    public PathItem copy() {
        return new PathItem(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "summary" -> ConverterUtils.toType((Object)this.getSummary(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "get" -> ConverterUtils.toType((Object)this.getGet(), type);
            case "put" -> ConverterUtils.toType((Object)this.getPut(), type);
            case "post" -> ConverterUtils.toType((Object)this.getPost(), type);
            case "delete" -> ConverterUtils.toType((Object)this.getDelete(), type);
            case "options" -> ConverterUtils.toType((Object)this.getOptions(), type);
            case "head" -> ConverterUtils.toType((Object)this.getHead(), type);
            case "patch" -> ConverterUtils.toType((Object)this.getPatch(), type);
            case "trace" -> ConverterUtils.toType((Object)this.getTrace(), type);
            case "servers" -> ConverterUtils.toType(this.getServers(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            default -> super.get(property, type);
        });
    }

    public Operation getDelete() {
        return this.delete;
    }

    public String getDescription() {
        return this.description;
    }

    public Operation getGet() {
        return this.get;
    }

    public Operation getHead() {
        return this.head;
    }

    public Operation getOptions() {
        return this.options;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Operation getPatch() {
        return this.patch;
    }

    public Operation getPost() {
        return this.post;
    }

    public Operation getPut() {
        return this.put;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation getTrace() {
        return this.trace;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.delete), (Object)"delete").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.get), (Object)"get").addIf(Utils.nn((Object)this.head), (Object)"head").addIf(Utils.nn((Object)this.options), (Object)"options").addIf(Utils.nn(this.parameters), (Object)"parameters").addIf(Utils.nn((Object)this.patch), (Object)"patch").addIf(Utils.nn((Object)this.post), (Object)"post").addIf(Utils.nn((Object)this.put), (Object)"put").addIf(Utils.nn(this.servers), (Object)"servers").addIf(Utils.nn((Object)this.summary), (Object)"summary").addIf(Utils.nn((Object)this.trace), (Object)"trace").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public PathItem set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "delete" -> this.setDelete((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "get" -> this.setGet((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "head" -> this.setHead((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "options" -> this.setOptions((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "patch" -> this.setPatch((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "parameters" -> this.setParameters(CollectionUtils.listb(Parameter.class).addAny(new Object[]{value}).sparse().build());
            case "post" -> this.setPost((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "put" -> this.setPut((Operation)ConverterUtils.toType((Object)value, Operation.class));
            case "servers" -> this.setServers(CollectionUtils.listb(Server.class).addAny(new Object[]{value}).sparse().build());
            case "summary" -> this.setSummary(Utils.s((Object)value));
            case "trace" -> this.setTrace((Operation)ConverterUtils.toType((Object)value, Operation.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public PathItem setDelete(Operation value) {
        this.delete = value;
        return this;
    }

    public PathItem setDescription(String value) {
        this.description = value;
        return this;
    }

    public PathItem setGet(Operation value) {
        this.get = value;
        return this;
    }

    public PathItem setHead(Operation value) {
        this.head = value;
        return this;
    }

    public PathItem setOptions(Operation value) {
        this.options = value;
        return this;
    }

    public PathItem setParameters(List<Parameter> value) {
        this.parameters = value;
        return this;
    }

    public PathItem setPatch(Operation value) {
        this.patch = value;
        return this;
    }

    public PathItem setPost(Operation value) {
        this.post = value;
        return this;
    }

    public PathItem setPut(Operation value) {
        this.put = value;
        return this;
    }

    public PathItem setServers(List<Server> value) {
        this.servers = value;
        return this;
    }

    public PathItem setSummary(String value) {
        this.summary = value;
        return this;
    }

    public PathItem setTrace(Operation value) {
        this.trace = value;
        return this;
    }

    @Override
    public PathItem strict() {
        super.strict();
        return this;
    }

    @Override
    public PathItem strict(Object value) {
        super.strict(value);
        return this;
    }
}

