/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.Optional;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class UrlPath {
    final String[] parts;
    final String path;

    public static UrlPath of(String path) {
        if (Utils.nn((Object)path) && !path.startsWith("/")) {
            throw ThrowableUtils.illegalArg((String)"Invalid path specified. Must be null or start with '/' per HttpServletRequest.getPathInfo().", (Object[])new Object[0]);
        }
        return new UrlPath(path);
    }

    UrlPath(String path) {
        this.path = path;
        this.parts = path == null ? new String[]{} : StringUtils.splita((String)path.substring(1), (char)'/');
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = StringUtils.urlDecode((String)this.parts[i]);
        }
    }

    public Optional<String> getFileName() {
        if (this.parts.length == 0) {
            return Utils.opte();
        }
        String p = this.parts[this.parts.length - 1];
        if (p.indexOf(46) == -1) {
            return Utils.opte();
        }
        return Utils.opt((Object)p);
    }

    public String[] getParts() {
        return this.parts;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isTrailingSlash() {
        return Utils.nn((Object)this.path) && this.path.endsWith("/");
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"parts", (Object)this.parts).a((Object)"raw", (Object)this.path);
    }

    public String toString() {
        return Utils.r(this.properties());
    }
}

