/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.juneau.commons.utils.AssertionUtils;

public class NoCloseOutputStream
extends OutputStream {
    private final OutputStream os;

    public NoCloseOutputStream(OutputStream os) {
        this.os = AssertionUtils.assertArgNotNull("os", os);
    }

    @Override
    public void close() throws IOException {
        this.os.flush();
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        AssertionUtils.assertArgNotNull("b", b);
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        AssertionUtils.assertArgNotNull("b", b);
        this.os.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }
}

