/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.settings.Setting;
import org.apache.juneau.commons.settings.Settings;
import org.apache.juneau.commons.utils.Utils;

public class ThrowableUtils {
    static Setting<Boolean> VERBOSE = Settings.get().get("juneau.enableVerboseExceptions").asBoolean();

    public static BeanRuntimeException bex(Class<?> c, String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(c, msg, args));
    }

    public static BeanRuntimeException bex(ClassInfo c, String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(c.inner(), msg, args));
    }

    public static BeanRuntimeException bex(String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(msg, args));
    }

    public static BeanRuntimeException bex(Throwable cause) {
        return ThrowableUtils.log(new BeanRuntimeException(cause));
    }

    public static BeanRuntimeException bex(Throwable e, Class<?> c, String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(e, c, msg, args));
    }

    public static BeanRuntimeException bex(Throwable e, ClassInfo c, String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(e, c.inner(), msg, args));
    }

    public static BeanRuntimeException bex(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new BeanRuntimeException(Utils.f(msg, args), new Object[]{cause}));
    }

    public static ExecutableException exex(String msg, Object ... args) {
        return ThrowableUtils.log(new ExecutableException(msg, args));
    }

    public static ExecutableException exex(Throwable cause) {
        return ThrowableUtils.log(new ExecutableException(cause));
    }

    public static ExecutableException exex(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new ExecutableException(cause, msg, args));
    }

    public static <T> T castException(Class<T> type, Throwable t) {
        return (T)Utils.safeSupplier(() -> type.isInstance(t) ? type.cast(t) : type.getConstructor(Throwable.class).newInstance(t));
    }

    public static <T extends Throwable> Optional<T> findCause(Throwable e, Class<T> cause) {
        while (Utils.nn(e)) {
            if (cause.isInstance(e)) {
                return Utils.opt((Throwable)cause.cast(e));
            }
            e = e.getCause();
        }
        return Utils.opte();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    public static void printStackTrace(Throwable t, PrintWriter pw, Integer maxDepth) {
        try {
            Throwable cause;
            pw.println(t);
            StackTraceElement[] stackTrace = t.getStackTrace();
            int depth = maxDepth != null && maxDepth > 0 ? Math.min(maxDepth, stackTrace.length) : stackTrace.length;
            for (int i = 0; i < depth; ++i) {
                pw.println("\tat " + String.valueOf(stackTrace[i]));
            }
            if (maxDepth != null && maxDepth > 0 && stackTrace.length > maxDepth) {
                pw.println("\t... (" + (stackTrace.length - maxDepth) + " more)");
            }
            if ((cause = t.getCause()) != null && cause != t) {
                pw.print("Caused by: ");
                ThrowableUtils.printStackTrace(cause, pw, maxDepth);
            }
        }
        catch (Exception e) {
            pw.println("Error printing stack trace: " + e.getMessage());
        }
    }

    public static void printStackTrace(Throwable t, Integer maxDepth) {
        ThrowableUtils.printStackTrace(t, new PrintWriter(System.err, true), maxDepth);
    }

    public static <T extends Throwable> T getThrowableCause(Class<T> c, Throwable t) {
        while (Utils.nn(t)) {
            if (!c.isInstance(t = t.getCause())) continue;
            return (T)((Throwable)c.cast(t));
        }
        return null;
    }

    public static int hash(Throwable t, String stopClass) {
        int i = 0;
        while (Utils.nn(t)) {
            for (StackTraceElement e : t.getStackTrace()) {
                if (e.getClassName().equals(stopClass)) break;
                if (e.getClassName().indexOf(36) != -1) continue;
                i ^= e.hashCode();
            }
            t = t.getCause();
        }
        return i;
    }

    public static IllegalArgumentException illegalArg(String msg, Object ... args) {
        return ThrowableUtils.log(new IllegalArgumentException(Utils.f(msg, args)));
    }

    private static <T extends Throwable> T log(T exception) {
        if (VERBOSE.orElse(false).booleanValue()) {
            exception.printStackTrace();
        }
        return exception;
    }

    public static IllegalStateException illegalState(String msg, Object ... args) {
        return ThrowableUtils.log(new IllegalStateException(Utils.f(msg, args)));
    }

    public static IllegalArgumentException illegalArg(Throwable cause) {
        return ThrowableUtils.log(new IllegalArgumentException(cause));
    }

    public static IllegalArgumentException illegalArg(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new IllegalArgumentException(Utils.f(msg, args), cause));
    }

    public static IOException ioex(String msg, Object ... args) {
        return ThrowableUtils.log(new IOException(Utils.f(msg, args)));
    }

    public static IOException ioex(Throwable cause) {
        return ThrowableUtils.log(new IOException(cause));
    }

    public static IOException ioex(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new IOException(Utils.f(msg, args), cause));
    }

    public static String lm(Throwable t) {
        return t.getLocalizedMessage();
    }

    public static RuntimeException rex(String msg, Object ... args) {
        return ThrowableUtils.log(new RuntimeException(Utils.f(msg, args)));
    }

    public static RuntimeException rex(Throwable cause) {
        return ThrowableUtils.log(new RuntimeException(cause));
    }

    public static RuntimeException rex(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new RuntimeException(Utils.f(msg, args), cause));
    }

    public static RuntimeException toRex(Throwable cause) {
        return ThrowableUtils.castException(RuntimeException.class, cause);
    }

    public static UnsupportedOperationException unsupportedOp() {
        return ThrowableUtils.log(new UnsupportedOperationException("Not supported."));
    }

    public static UnsupportedOperationException unsupportedOp(String msg, Object ... args) {
        return ThrowableUtils.log(new UnsupportedOperationException(Utils.f(msg, args)));
    }

    public static UnsupportedOperationException unsupportedOp(Throwable cause) {
        return ThrowableUtils.log(new UnsupportedOperationException(cause));
    }

    public static UnsupportedOperationException unsupportedOp(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.log(new UnsupportedOperationException(Utils.f(msg, args), cause));
    }

    public static UnsupportedOperationException unsupportedOpReadOnly() {
        return ThrowableUtils.log(new UnsupportedOperationException("Object is read only."));
    }

    @FunctionalInterface
    public static interface SupplierWithThrowable<T> {
        public T get() throws Throwable;
    }
}

