/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.reflect.ElementInfo;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ParameterInfo
extends ElementInfo
implements Annotatable {
    static final ResettableSupplier<Boolean> DISABLE_PARAM_NAME_DETECTION = Utils.memr(() -> Boolean.getBoolean("juneau.disableParamNameDetection"));
    private final ExecutableInfo executable;
    private final Parameter inner;
    private final int index;
    private final ClassInfo type;
    private final Supplier<List<AnnotationInfo<Annotation>>> annotations;
    private final Supplier<List<ParameterInfo>> matchingParameters;
    private final ResettableSupplier<String> resolvedName = Utils.memr(this::findNameInternal);
    private final ResettableSupplier<String> resolvedQualifier = Utils.memr(this::findQualifierInternal);

    public static ParameterInfo of(Parameter inner) {
        ExecutableInfo execInfo;
        AssertionUtils.assertArgNotNull("inner", inner);
        Executable exec = inner.getDeclaringExecutable();
        if (exec instanceof Constructor) {
            Constructor c = (Constructor)exec;
            execInfo = ConstructorInfo.of(c);
        } else {
            execInfo = MethodInfo.of((Method)exec);
        }
        return execInfo.getParameters().stream().filter(x -> Utils.eq(x.inner(), inner)).findFirst().orElse(null);
    }

    static void reset() {
        DISABLE_PARAM_NAME_DETECTION.reset();
    }

    protected ParameterInfo(ExecutableInfo executable, Parameter inner, int index, ClassInfo type) {
        super(inner.getModifiers());
        this.executable = executable;
        this.inner = inner;
        this.index = index;
        this.type = type;
        this.annotations = Utils.mem(() -> CollectionUtils.stream(inner.getAnnotations()).flatMap(a -> AnnotationUtils.streamRepeated(a)).map(a -> this.ai(this, a)).toList());
        this.matchingParameters = Utils.mem(this::findMatchingParameters);
    }

    public boolean canAccept(Object value) {
        return this.getParameterType().canAcceptArg(value);
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.PARAMETER_TYPE;
    }

    public AnnotatedType getAnnotatedType() {
        return this.inner.getAnnotatedType();
    }

    public List<AnnotationInfo<Annotation>> getAnnotations() {
        return this.annotations.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> type) {
        return this.getAnnotations().stream().filter(x -> x.isType(type)).map(x -> x);
    }

    public ConstructorInfo getConstructor() {
        return this.executable.isConstructor() ? (ConstructorInfo)this.executable : null;
    }

    public ExecutableInfo getDeclaringExecutable() {
        return this.executable;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getLabel() {
        ExecutableInfo exec = this.getDeclaringExecutable();
        String label = exec.getDeclaringClass().getNameSimple() + "." + exec.getShortName();
        return label + "[" + this.index + "]";
    }

    public List<ParameterInfo> getMatchingParameters() {
        return this.matchingParameters.get();
    }

    public MethodInfo getMethod() {
        return this.executable.isConstructor() ? null : (MethodInfo)this.executable;
    }

    @Override
    public int getModifiers() {
        return this.inner.getModifiers();
    }

    public String getName() {
        String name = this.getResolvedName();
        return name != null ? name : this.inner.getName();
    }

    public Type getParameterizedType() {
        return this.inner.getParameterizedType();
    }

    public ClassInfo getParameterType() {
        return this.type;
    }

    public String getResolvedName() {
        return this.resolvedName.get();
    }

    public String getResolvedQualifier() {
        return this.resolvedQualifier.get();
    }

    public boolean hasName() {
        return this.getResolvedName() != null;
    }

    public Parameter inner() {
        return this.inner;
    }

    public boolean equals(Object obj) {
        ParameterInfo other;
        return obj instanceof ParameterInfo && Utils.eq(this, other = (ParameterInfo)obj, (x, y) -> Utils.eq(x.inner, y.inner));
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    @Override
    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.SYNTHETIC -> this.isSynthetic();
            case ElementFlag.NOT_SYNTHETIC -> {
                if (!this.isSynthetic()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.VARARGS -> this.isVarArgs();
            case ElementFlag.NOT_VARARGS -> {
                if (!this.isVarArgs()) {
                    yield true;
                }
                yield false;
            }
            default -> super.is(flag);
        };
    }

    public boolean isImplicit() {
        return this.inner.isImplicit();
    }

    public boolean isNamePresent() {
        return this.inner.isNamePresent();
    }

    public boolean isSynthetic() {
        return this.inner.isSynthetic();
    }

    public boolean isType(Class<?> c) {
        return this.getParameterType().is(c);
    }

    public boolean isVarArgs() {
        return this.inner.isVarArgs();
    }

    public String toString() {
        return this.executable.getSimpleName() + "[" + this.index + "]";
    }

    private List<ParameterInfo> findMatchingParameters() {
        ExecutableInfo executableInfo = this.executable;
        if (executableInfo instanceof ConstructorInfo) {
            ConstructorInfo executable2 = (ConstructorInfo)executableInfo;
            ArrayList<ParameterInfo> list = new ArrayList<ParameterInfo>();
            list.add(this);
            ClassInfo cc = executable2.getDeclaringClass().getSuperclass();
            while (Utils.nn(cc)) {
                for (ConstructorInfo pc : cc.getDeclaredConstructors()) {
                    List<ParameterInfo> params = pc.getParameters();
                    if (this.index >= params.size() || !this.getParameterType().is(params.get(this.index).getParameterType())) continue;
                    list.add(params.get(this.index));
                }
                cc = cc.getSuperclass();
            }
            return list;
        }
        return ((MethodInfo)this.executable).getMatchingMethods().stream().map(m -> m.getParameter(this.index)).toList();
    }

    private String findNameInternal() {
        for (ParameterInfo mp : this.getMatchingParameters()) {
            for (AnnotationInfo<Annotation> ai : mp.getAnnotations()) {
                String value;
                if (!ai.hasSimpleName("Name") || (value = (String)ai.getValue().orElse(null)) == null) continue;
                return value;
            }
        }
        return Utils.opt(this.inner).filter(x -> x.isNamePresent()).filter(x -> DISABLE_PARAM_NAME_DETECTION.get() == false).map(x -> x.getName()).orElse(null);
    }

    private String findQualifierInternal() {
        return this.getMatchingParameters().stream().flatMap(mp -> mp.getAnnotations().stream()).filter(ai -> ai.hasSimpleName("Named") || ai.hasSimpleName("Qualifier")).map(ai -> ai.getValue().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

