/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.text.ParseException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class StringExpressionMatcher {
    private static final AsciiSet WS = AsciiSet.of(" \t");
    private static final AsciiSet OP = AsciiSet.of(",|&");
    private static final AsciiSet META = AsciiSet.of("*?");
    private final Exp exp;

    private static Exp parseOperand(String operand) {
        char c;
        boolean hasMeta = false;
        for (int i = 0; i < operand.length() && !hasMeta; hasMeta |= META.contains(c), ++i) {
            c = operand.charAt(i);
        }
        return hasMeta ? new Match(operand) : new Eq(operand);
    }

    public StringExpressionMatcher(String expression) throws ParseException {
        this.exp = this.parse(expression);
    }

    public Set<String> getTokens() {
        TreeSet<String> set = new TreeSet<String>();
        this.exp.appendTokens(set);
        return set;
    }

    public boolean matches(String input) {
        return Utils.nn(input) && this.exp.matches(input);
    }

    public String toString() {
        return this.exp.toString();
    }

    private Exp parse(String expression) throws ParseException {
        if (Utils.b(expression)) {
            return new Never();
        }
        expression = expression.trim();
        List<Exp> ors = CollectionUtils.list(new Exp[0]);
        List<Exp> ands = CollectionUtils.list(new Exp[0]);
        StateEnum state = StateEnum.S1;
        int i = 0;
        int mark = -1;
        int pDepth = 0;
        boolean error = false;
        for (i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (state == StateEnum.S1) {
                if (WS.contains(c)) continue;
                if (c == '(') {
                    state = StateEnum.S2;
                    pDepth = 0;
                    mark = i + 1;
                    continue;
                }
                if (OP.contains(c)) {
                    error = true;
                    break;
                }
                state = StateEnum.S3;
                mark = i;
                continue;
            }
            if (state == StateEnum.S2) {
                if (c == '(') {
                    ++pDepth;
                }
                if (c != ')') continue;
                if (pDepth > 0) {
                    --pDepth;
                    continue;
                }
                ands.add(this.parse(expression.substring(mark, i)));
                mark = -1;
                state = StateEnum.S4;
                continue;
            }
            if (state == StateEnum.S3) {
                if (!WS.contains(c) && !OP.contains(c)) continue;
                ands.add(StringExpressionMatcher.parseOperand(expression.substring(mark, i)));
                mark = -1;
                if (WS.contains(c)) {
                    state = StateEnum.S4;
                    continue;
                }
                --i;
                state = StateEnum.S5;
                continue;
            }
            if (state == StateEnum.S4) {
                if (WS.contains(c)) continue;
                if (OP.contains(c)) {
                    --i;
                    state = StateEnum.S5;
                    continue;
                }
                error = true;
                break;
            }
            if (state == StateEnum.S5) {
                if (c == '&') {
                    state = StateEnum.S6;
                    continue;
                }
                if (ands.size() == 1) {
                    ors.add(ands.get(0));
                } else {
                    ors.add(new And(ands));
                }
                ands.clear();
                if (c == '|') {
                    state = StateEnum.S7;
                    continue;
                }
                state = StateEnum.S1;
                continue;
            }
            if (state == StateEnum.S6) {
                if (WS.contains(c)) continue;
                if (c != '&') {
                    --i;
                }
                state = StateEnum.S1;
                continue;
            }
            if (WS.contains(c)) continue;
            if (c != '|') {
                --i;
            }
            state = StateEnum.S1;
        }
        if (error) {
            throw new ParseException("Invalid character in expression '" + expression + "' at position " + i + ". state=" + String.valueOf((Object)state), i);
        }
        if (state == StateEnum.S1) {
            throw new ParseException("Could not find beginning of clause in '" + expression + "'", i);
        }
        if (state == StateEnum.S2) {
            throw new ParseException("Could not find matching parenthesis in expression '" + expression + "'", i);
        }
        if (state == StateEnum.S5 || state == StateEnum.S6 || state == StateEnum.S7) {
            throw new ParseException("Dangling clause in expression '" + expression + "'", i);
        }
        if (mark != -1) {
            ands.add(StringExpressionMatcher.parseOperand(expression.substring(mark, expression.length())));
        }
        if (ands.size() == 1) {
            ors.add(ands.get(0));
        } else {
            ors.add(new And(ands));
        }
        if (ors.size() == 1) {
            return ors.get(0);
        }
        return new Or(ors);
    }

    static class Match
    extends Exp {
        final Pattern p;
        final String operand;

        Match(String operand) {
            this.operand = operand;
            this.p = StringUtils.getMatchPattern(operand);
        }

        public String toString() {
            return "[* " + this.p.pattern().replaceAll("\\\\[QE]", "") + "]";
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        @Override
        boolean matches(String input) {
            return this.p.matcher(input).matches();
        }
    }

    static class Eq
    extends Exp {
        final String operand;

        Eq(String operand) {
            this.operand = operand;
        }

        public String toString() {
            return "[= " + this.operand + "]";
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        @Override
        boolean matches(String input) {
            return this.operand.equals(input);
        }
    }

    static abstract class Exp {
        Exp() {
        }

        void appendTokens(Set<String> set) {
        }

        abstract boolean matches(String var1);
    }

    static class Never
    extends Exp {
        Never() {
        }

        public String toString() {
            return "(NEVER)";
        }

        @Override
        boolean matches(String input) {
            return false;
        }
    }

    static class And
    extends Exp {
        Exp[] clauses;

        And(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        public String toString() {
            return "(& " + StringUtils.join((Object[])this.clauses, " ") + ")";
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        @Override
        boolean matches(String input) {
            for (Exp e : this.clauses) {
                if (e.matches(input)) continue;
                return false;
            }
            return true;
        }
    }

    static class Or
    extends Exp {
        Exp[] clauses;

        Or(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        public String toString() {
            return "(| " + StringUtils.join((Object[])this.clauses, " ") + ")";
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        @Override
        boolean matches(String input) {
            for (Exp e : this.clauses) {
                if (!e.matches(input)) continue;
                return true;
            }
            return false;
        }
    }
}

