/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class AnnotationObject
implements Annotation {
    private final Class<? extends Annotation> annotationType;
    private Supplier<Integer> hashCode = Utils.mem(() -> AnnotationUtils.hash(this));

    public AnnotationObject(Builder b) {
        AssertionUtils.assertArgNotNull("b", b);
        this.annotationType = b.getAnnotationType();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Annotation)) return false;
        Annotation o2 = (Annotation)o;
        if (!this.annotationType.isInstance(o)) return false;
        if (!Utils.eq(this, o2)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode.get();
    }

    protected Map<String, Object> propertyMap() {
        Map<String, Object> m = CollectionUtils.mapb_so().sorted().build();
        CollectionUtils.stream(this.annotationType().getDeclaredMethods()).filter(x -> x.getParameterCount() == 0 && x.getDeclaringClass().isAnnotation()).sorted(Comparator.comparing(Method::getName)).forEach(x -> m.put(x.getName(), Utils.safeSupplier(() -> x.invoke((Object)this, new Object[0]))));
        return m;
    }

    @Override
    public String toString() {
        return Utils.r(this.propertyMap());
    }

    public static class Builder {
        private Class<? extends Annotation> annotationType;

        public Builder(Class<? extends Annotation> annotationType) {
            this.annotationType = AssertionUtils.assertArgNotNull("annotationType", annotationType);
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }
    }
}

