/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.net;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.jena.atlas.io.IOX;

public class Host {
    public static String getHostAddressForIRI() {
        try {
            InetAddress addr = Host.getLocalHostLANAddress$();
            if (addr == null) {
                return null;
            }
            Object hostAddress = addr.getHostAddress();
            if (addr instanceof Inet6Address) {
                hostAddress = ((String)hostAddress).replaceFirst("%.*", "");
                hostAddress = "[" + (String)hostAddress + "]";
            }
            return hostAddress;
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static InetAddress getLocalHostLANAddress() {
        try {
            return Host.getLocalHostLANAddress$();
        }
        catch (IOException ioException) {
            throw IOX.exception(ioException);
        }
    }

    private static InetAddress getLocalHostLANAddress$() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + String.valueOf(e));
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

