/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.store;

import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.store.StateSearchKey;

public class KeyValueEntity {
    private String key;
    private StateSearchKey stateSearchKey;
    private String fileName;
    private String jsonValue;

    private KeyValueEntity() {
    }

    public KeyValueEntity(String key, String jsonValue, String fileName) {
        this.key = key;
        this.jsonValue = jsonValue;
        this.stateSearchKey = StateSearchKey.ACCEPTED;
        this.fileName = fileName;
    }

    public String getKey() {
        return this.key;
    }

    public String getFileName() {
        return this.fileName;
    }

    public StateSearchKey getStateSearchKey() {
        return this.stateSearchKey;
    }

    public KeyValueEntity setStateSearchKey(StateSearchKey stateSearchKey) {
        this.stateSearchKey = stateSearchKey;
        return this;
    }

    public String getJsonValue() {
        return this.jsonValue;
    }

    public KeyValueEntity setJsonValue(String jsonValue) {
        this.jsonValue = jsonValue;
        return this;
    }

    public JobProfile getAsJobProfile() {
        return JobProfile.parseJsonStr(this.getJsonValue());
    }

    public OffsetProfile getAsOffsetProfile() {
        return OffsetProfile.parseJsonStr(this.getJsonValue());
    }

    public TaskProfile getAsTaskProfile() {
        return TaskProfile.parseJsonStr(this.getJsonValue());
    }

    public InstanceProfile getAsInstanceProfile() {
        return InstanceProfile.parseJsonStr(this.getJsonValue());
    }

    public boolean checkFinished() {
        return this.stateSearchKey.equals((Object)StateSearchKey.SUCCESS) || this.stateSearchKey.equals((Object)StateSearchKey.FAILED);
    }
}

