/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentConfiguration.class);
    private static final String DEFAULT_CONFIG_FILE = "agent.properties";
    private static final String EXT_CONFIG_FILE = "agent_ext.properties";
    private static final String TMP_CONFIG_FILE = ".tmp.agent.properties";
    private static final ArrayList<String> LOCAL_RESOURCES = new ArrayList();
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static volatile AgentConfiguration agentConf = null;

    private AgentConfiguration() {
        for (String fileName : LOCAL_RESOURCES) {
            super.loadPropertiesResource(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentConfiguration getAgentConf() {
        if (agentConf != null) return agentConf;
        Class<AgentConfiguration> clazz = AgentConfiguration.class;
        synchronized (AgentConfiguration.class) {
            if (agentConf != null) return agentConf;
            agentConf = new AgentConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return agentConf;
        }
    }

    private String getNextBackupFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = format.format(new Date(System.currentTimeMillis()));
        return "agent.properties." + dateStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushToLocalPropertiesFile() {
        LOCK.writeLock().lock();
        try {
            String agentConfParent = this.get("agent.conf.parent", "conf");
            File sourceFile = new File(agentConfParent, DEFAULT_CONFIG_FILE);
            File targetFile = new File(agentConfParent, this.getNextBackupFileName());
            File tmpFile = new File(agentConfParent, TMP_CONFIG_FILE);
            if (sourceFile.exists()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            List<String> tmpCache = this.getStorageList();
            FileUtils.writeLines((File)tmpFile, tmpCache);
            FileUtils.copyFile((File)tmpFile, (File)sourceFile);
            boolean result = tmpFile.delete();
            if (!result) {
                LOGGER.warn("cannot delete file {}", (Object)tmpFile);
            }
        }
        catch (Exception ex) {
            LOGGER.error("error while flush agent conf to local", (Throwable)ex);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public long maxLastModifiedTime() {
        long maxLastModifiedTime = 0L;
        for (String fileName : LOCAL_RESOURCES) {
            long fileLastModified;
            File file = new File(this.getConfigLocation(fileName).getFile());
            if (!file.exists() || (fileLastModified = file.lastModified()) <= maxLastModifiedTime) continue;
            maxLastModifiedTime = fileLastModified;
        }
        return maxLastModifiedTime;
    }

    public void reloadFromLocalPropertiesFile() {
        for (String fileName : LOCAL_RESOURCES) {
            super.loadPropertiesResource(fileName);
        }
    }

    @Override
    public boolean allRequiredKeyExist() {
        return true;
    }

    static {
        LOCAL_RESOURCES.add(DEFAULT_CONFIG_FILE);
        LOCAL_RESOURCES.add(EXT_CONFIG_FILE);
    }
}

