/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.time.Instant;
import java.util.List;
import java.util.OptionalLong;

public class LogicalDecodingMessage
implements ReplicationMessage {
    private final ReplicationMessage.Operation operation;
    private final Instant commitTime;
    private final Long transactionId;
    private final boolean isTransactional;
    private final String prefix;
    private final byte[] content;

    public LogicalDecodingMessage(ReplicationMessage.Operation op, Instant commitTimestamp, Long transactionId, boolean isTransactional, String prefix, byte[] content) {
        this.operation = op;
        this.commitTime = commitTimestamp;
        this.transactionId = transactionId;
        this.isTransactional = isTransactional;
        this.prefix = prefix;
        this.content = content;
    }

    @Override
    public boolean isLastEventForLsn() {
        return !this.isTransactional;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        return this.operation;
    }

    @Override
    public Instant getCommitTime() {
        return this.commitTime;
    }

    @Override
    public OptionalLong getTransactionId() {
        return this.transactionId == null ? OptionalLong.empty() : OptionalLong.of(this.transactionId);
    }

    @Override
    public String getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasTypeMetadata() {
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public byte[] getContent() {
        return this.content;
    }
}

