/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionRepository;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.util.WorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowContextBuilderImpl
implements WorkflowContextBuilder {
    private static final Logger log = LoggerFactory.getLogger(WorkflowContextBuilderImpl.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ProcessDefinitionRepository definitionRepository;
    @Autowired
    private WorkflowProcessEntityMapper processEntityMapper;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;

    @Override
    public WorkflowContext buildContextForProcess(String name, String applicant, ProcessForm form) {
        WorkflowProcess process = this.definitionRepository.get(name).clone();
        return new WorkflowContext().setOperator(applicant).setProcess(process).setProcessForm(form);
    }

    @Override
    public WorkflowContext buildContextForProcess(Integer processId) {
        WorkflowProcessEntity processEntity = this.processEntityMapper.selectById(processId);
        Preconditions.expectNotNull((Object)processEntity, (String)("process not exist with id: " + processId));
        WorkflowProcess process = this.definitionRepository.get(processEntity.getName()).clone();
        return new WorkflowContext().setOperator(processEntity.getApplicant()).setProcess(process).setProcessForm((ProcessForm)WorkflowUtils.parseProcessForm(this.objectMapper, processEntity.getFormData(), process)).setProcessEntity(processEntity);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskId, WorkflowAction action, String remark, String operator) {
        return this.buildContextForTask(taskId, action, null, null, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskId, WorkflowAction action, TaskForm taskForm, String remark, String operator) {
        return this.buildContextForTask(taskId, action, taskForm, null, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskId, WorkflowAction action, List<String> transferToUsers, String remark, String operator) {
        return this.buildContextForTask(taskId, action, null, transferToUsers, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskId, WorkflowAction action) {
        WorkflowTaskEntity taskEntity = this.taskEntityMapper.selectById(taskId);
        WorkflowProcess process = this.definitionRepository.get(taskEntity.getProcessName()).clone();
        Object taskForm = WorkflowUtils.parseTaskForm(this.objectMapper, taskEntity, process);
        List<String> transferToUsers = this.getTransferToUsers(taskEntity.getExtParams());
        return this.buildContextForTask(taskId, action, (TaskForm)taskForm, transferToUsers, taskEntity.getRemark(), taskEntity.getOperator());
    }

    private WorkflowContext buildContextForTask(Integer taskId, WorkflowAction action, TaskForm taskForm, List<String> transferToUsers, String remark, String operator) {
        WorkflowTaskEntity taskEntity = this.taskEntityMapper.selectById(taskId);
        Preconditions.expectNotNull((Object)taskEntity, (String)("task not exist with id: " + taskId));
        WorkflowProcessEntity processEntity = this.processEntityMapper.selectById(taskEntity.getProcessId());
        WorkflowProcess process = this.definitionRepository.get(processEntity.getName()).clone();
        Object processForm = WorkflowUtils.parseProcessForm(this.objectMapper, processEntity.getFormData(), process);
        WorkflowTask task = process.getTaskByName(taskEntity.getName());
        return new WorkflowContext().setProcess(process).setOperator(processEntity.getApplicant()).setProcessForm((ProcessForm)processForm).setProcessEntity(processEntity).setCurrentElement(task).setActionContext(new WorkflowContext.ActionContext().setAction(action).setTaskEntity(taskEntity).setTask(task).setForm(taskForm).setTransferToUsers(transferToUsers).setOperator(operator).setRemark(remark));
    }

    private List<String> getTransferToUsers(String ext) {
        if (StringUtils.isEmpty((CharSequence)ext)) {
            return Lists.newArrayList();
        }
        try {
            Map extMap = (Map)this.objectMapper.readValue(ext, (JavaType)this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
            if (!extMap.containsKey("transferToUsers")) {
                return Lists.newArrayList();
            }
            if (extMap.get("transferToUsers") instanceof List) {
                return (List)extMap.get("transferToUsers");
            }
        }
        catch (JsonProcessingException e) {
            log.error("parse transfer users error: ", (Throwable)e);
            throw new JsonException("parse transfer users error");
        }
        return null;
    }
}

