/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MaskDataUtils {
    private static final List<String> KEYWORDS = Arrays.asList("password", "pwd", "pass", "token", "secret_token", "secretToken", "secret_id", "secretId", "secret_key", "secretKey", "public_key", "publicKey", "gateway.url");
    private static final List<String> SEPARATORS = Arrays.asList(":", "=", "\": \"", "\":\"");
    private static final List<Character> STOP_CHARACTERS = Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'));
    private static final List<Character> KNOWN_DELIMITERS = Collections.unmodifiableList(Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>')));

    public static void mask(StringBuilder stringBuilder) {
        int length = stringBuilder.length();
        for (int pos = 0; pos < length; ++pos) {
            boolean maskedThisCharacter = false;
            int newPos = MaskDataUtils.maskData(stringBuilder, '*', pos, length);
            boolean bl = maskedThisCharacter = newPos != pos;
            if (maskedThisCharacter) {
                length = stringBuilder.length();
                maskedThisCharacter = false;
            }
            if (maskedThisCharacter) continue;
            while (pos < length && !Character.isWhitespace(stringBuilder.charAt(pos)) && !STOP_CHARACTERS.contains(Character.valueOf(stringBuilder.charAt(pos)))) {
                ++pos;
            }
        }
    }

    private static int mask(StringBuilder builder, char maskChar, int startPos, int endPos) {
        String masked = "" + maskChar + maskChar + maskChar + maskChar + maskChar + maskChar;
        builder.replace(startPos, endPos, masked);
        return startPos + 6;
    }

    public static int maskData(StringBuilder builder, char maskChar, int startPos, int buffLength) {
        int charPos = startPos;
        if (charPos + 5 > buffLength) {
            return startPos;
        }
        Character character = Character.valueOf(builder.charAt(charPos));
        if (MaskDataUtils.isKeyWorkdStart(character)) {
            int keywordStart = 0;
            int keywordLength = 0;
            String keywordUsed = null;
            for (String keyword : KEYWORDS) {
                keywordStart = StringUtils.indexOfIgnoreCase(builder, keyword, charPos);
                if (!MaskDataUtils.keywordStartAtRightPosition(keywordStart, charPos)) continue;
                keywordLength = keyword.length();
                keywordUsed = keyword;
                break;
            }
            if (keywordStart != startPos && keywordStart != startPos + 1) {
                return startPos;
            }
            for (String separator : SEPARATORS) {
                int endPos;
                int delimiterPos;
                int idxSeparator = StringUtils.indexOf((CharSequence)builder, separator, keywordStart + keywordLength);
                for (delimiterPos = keywordStart + keywordLength; delimiterPos < buffLength && MaskDataUtils.isDelimiter(builder.charAt(delimiterPos)); ++delimiterPos) {
                }
                if (delimiterPos != idxSeparator || (endPos = MaskDataUtils.detectEnd(builder, buffLength, charPos = MaskDataUtils.maskStartPosition(idxSeparator, separator, builder), keywordUsed, keywordLength, separator)) <= charPos) continue;
                return MaskDataUtils.mask(builder, maskChar, charPos, endPos);
            }
        }
        return startPos;
    }

    private static int detectEnd(StringBuilder builder, int buffLength, int startPos, String keyword, int keywordLength, String separator) {
        if (separator.charAt(0) == '>') {
            return MaskDataUtils.detectEndXml(builder, buffLength, startPos, keyword, keywordLength);
        }
        if (separator.contains("\"")) {
            return MaskDataUtils.detectEndJson(builder, buffLength, startPos);
        }
        return MaskDataUtils.detectEndNoXml(builder, buffLength, startPos);
    }

    private static int detectEndNoXml(StringBuilder builder, int buffLength, int startPos) {
        while (startPos < buffLength && !MaskDataUtils.isDelimiter(builder.charAt(startPos))) {
            ++startPos;
        }
        return startPos;
    }

    private static int detectEndJson(StringBuilder builder, int buffLength, int startPos) {
        while (startPos < buffLength && !MaskDataUtils.isEndOfJson(builder, startPos)) {
            ++startPos;
        }
        return startPos;
    }

    private static boolean isDelimiter(char character) {
        return Character.isWhitespace(character) || KNOWN_DELIMITERS.contains(Character.valueOf(character));
    }

    private static boolean isEndOfJson(StringBuilder builder, int pos) {
        return builder.charAt(pos) == '\"' && builder.charAt(pos - 1) != '\\';
    }

    private static int detectEndXml(StringBuilder builder, int buffLength, int startPos, String keyword, int keywordLength) {
        if (buffLength < startPos + keywordLength + 3) {
            return -1;
        }
        int passwordEnd = StringUtils.indexOfIgnoreCase(builder, keyword, startPos);
        if (passwordEnd > 0 && builder.charAt(passwordEnd - 1) == '/' && builder.charAt(passwordEnd - 2) == '<') {
            return passwordEnd - 2;
        }
        return -1;
    }

    private static boolean isKeyWorkdStart(Character character) {
        boolean result = false;
        for (String keyword : KEYWORDS) {
            result = character.equals(Character.valueOf(keyword.charAt(0))) || result;
        }
        return result;
    }

    private static boolean keywordStartAtRightPosition(int keywordStart, int pos) {
        return keywordStart >= 0 && (keywordStart == pos || keywordStart == pos + 1);
    }

    private static int maskStartPosition(int idxSeparator, String separator, StringBuilder builder) {
        int charPos;
        for (charPos = idxSeparator + separator.length(); charPos < builder.length() && MaskDataUtils.isDelimiter(builder.charAt(charPos)); ++charPos) {
        }
        return charPos;
    }

    public static String maskSensitiveMessage(String message) {
        StringBuilder buffer = new StringBuilder(message);
        MaskDataUtils.mask(buffer);
        return buffer.toString();
    }
}

