/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.metric;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.common.metric.CountMetric;
import org.apache.inlong.common.metric.Dimension;
import org.apache.inlong.common.metric.GaugeMetric;
import org.apache.inlong.common.metric.MetricItemMBean;
import org.apache.inlong.common.metric.MetricUtils;
import org.apache.inlong.common.metric.MetricValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricItem
implements MetricItemMBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetricItem.class);
    private String key;
    private Map<String, String> dimensions;
    private Map<String, AtomicLong> countMetrics;
    private Map<String, AtomicLong> gaugeMetrics;

    public static List<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    @Override
    public String getDimensionsKey() {
        if (this.key != null) {
            return this.key;
        }
        Map<String, String> dimensionMap = this.getDimensions();
        this.key = MetricUtils.getDimensionsKey(dimensionMap);
        return this.key;
    }

    @Override
    public Map<String, String> getDimensions() {
        if (this.dimensions != null) {
            return this.dimensions;
        }
        this.dimensions = new HashMap<String, String>();
        List<Field> fields = MetricItem.getDeclaredFieldsIncludingInherited(this.getClass());
        block2: for (Field field : fields) {
            field.setAccessible(true);
            for (Annotation fieldAnnotation : field.getAnnotations()) {
                if (!(fieldAnnotation instanceof Dimension)) continue;
                Dimension dimension = (Dimension)fieldAnnotation;
                String name = dimension.name();
                name = name != null && name.length() > 0 ? name : field.getName();
                try {
                    Object fieldValue = field.get(this);
                    String value = fieldValue == null ? "" : fieldValue.toString();
                    this.dimensions.put(name, value);
                }
                catch (Throwable t2) {
                    LOGGER.error(t2.getMessage(), t2);
                }
                continue block2;
            }
        }
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = new HashMap<String, String>();
        this.dimensions.putAll(dimensions);
    }

    @Override
    public Map<String, MetricValue> snapshot() {
        if (this.countMetrics == null || this.gaugeMetrics == null) {
            this.initMetricField();
        }
        HashMap<String, MetricValue> metrics = new HashMap<String, MetricValue>();
        this.countMetrics.forEach((key, value) -> metrics.put((String)key, MetricValue.of(key, value.getAndSet(0L))));
        this.gaugeMetrics.forEach((key, value) -> metrics.put((String)key, MetricValue.of(key, value.get())));
        return metrics;
    }

    protected void initMetricField() {
        this.countMetrics = new HashMap<String, AtomicLong>();
        this.gaugeMetrics = new HashMap<String, AtomicLong>();
        List<Field> fields = MetricItem.getDeclaredFieldsIncludingInherited(this.getClass());
        block4: for (Field field : fields) {
            field.setAccessible(true);
            for (Annotation fieldAnnotation : field.getAnnotations()) {
                Object fieldValue;
                String name;
                if (fieldAnnotation instanceof CountMetric) {
                    CountMetric countMetric = (CountMetric)fieldAnnotation;
                    name = countMetric.name();
                    name = name != null && name.length() > 0 ? name : field.getName();
                    try {
                        fieldValue = field.get(this);
                        if (!(fieldValue instanceof AtomicLong)) continue block4;
                        this.countMetrics.put(name, (AtomicLong)fieldValue);
                    }
                    catch (Throwable t2) {
                        LOGGER.error(t2.getMessage(), t2);
                    }
                    continue block4;
                }
                if (!(fieldAnnotation instanceof GaugeMetric)) continue;
                GaugeMetric gaugeMetric = (GaugeMetric)fieldAnnotation;
                name = gaugeMetric.name();
                name = name != null && name.length() > 0 ? name : field.getName();
                try {
                    fieldValue = field.get(this);
                    if (!(fieldValue instanceof AtomicLong)) continue block4;
                    this.gaugeMetrics.put(name, (AtomicLong)fieldValue);
                }
                catch (Throwable t3) {
                    LOGGER.error(t3.getMessage(), t3);
                }
                continue block4;
            }
        }
    }
}

