/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.json.JsonReadFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

@Internal
public class JsonRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final boolean failOnMissingField;
    private final boolean ignoreParseErrors;
    private final TypeInformation<RowData> resultTypeInfo;
    private final JsonToRowDataConverters.JsonToRowDataConverter runtimeConverter;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TimestampFormat timestampFormat;

    public JsonRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        if (ignoreParseErrors && failOnMissingField) {
            throw new IllegalArgumentException("JSON format doesn't support failOnMissingField and ignoreParseErrors are both enabled.");
        }
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
        this.failOnMissingField = failOnMissingField;
        this.ignoreParseErrors = ignoreParseErrors;
        this.runtimeConverter = new JsonToRowDataConverters(failOnMissingField, ignoreParseErrors, timestampFormat).createConverter((LogicalType)Preconditions.checkNotNull((Object)rowType));
        this.timestampFormat = timestampFormat;
        boolean hasDecimalType = LogicalTypeChecks.hasNested((LogicalType)rowType, t2 -> t2 instanceof DecimalType);
        if (hasDecimalType) {
            this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
        this.objectMapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
    }

    public RowData deserialize(@Nullable byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        try {
            return this.convertToRowData(this.deserializeToJsonNode(message));
        }
        catch (Throwable t2) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException(String.format("Failed to deserialize JSON '%s'.", new String(message)), t2);
        }
    }

    public JsonNode deserializeToJsonNode(byte[] message) throws IOException {
        return this.objectMapper.readTree(message);
    }

    public RowData convertToRowData(JsonNode message) {
        return (RowData)this.runtimeConverter.convert(message);
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDataDeserializationSchema that = (JsonRowDataDeserializationSchema)o;
        return this.failOnMissingField == that.failOnMissingField && this.ignoreParseErrors == that.ignoreParseErrors && this.resultTypeInfo.equals(that.resultTypeInfo) && this.timestampFormat.equals((Object)that.timestampFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failOnMissingField, this.ignoreParseErrors, this.resultTypeInfo, this.timestampFormat});
    }
}

