/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.formats.csv.RowDataToCsvConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CsvRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowDataToCsvConverters.RowDataToCsvConverter runtimeConverter;
    private final CsvMapper csvMapper;
    private final CsvSchema csvSchema;
    private final ObjectWriter objectWriter;
    private transient ObjectNode root;
    private transient RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext converterContext;

    private CsvRowDataSerializationSchema(RowType rowType, CsvSchema csvSchema) {
        this.rowType = rowType;
        this.runtimeConverter = RowDataToCsvConverters.createRowConverter(rowType);
        this.csvMapper = new CsvMapper();
        this.csvSchema = csvSchema.withLineSeparator("");
        this.objectWriter = this.csvMapper.writer(this.csvSchema);
    }

    public byte[] serialize(RowData row) {
        if (this.root == null) {
            this.root = this.csvMapper.createObjectNode();
            this.converterContext = new RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext(this.csvMapper, this.root);
        }
        try {
            this.runtimeConverter.convert(row, this.converterContext);
            return this.objectWriter.writeValueAsBytes(this.root);
        }
        catch (Throwable t2) {
            throw new RuntimeException(String.format("Could not serialize row '%s'.", row), t2);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CsvRowDataSerializationSchema that = (CsvRowDataSerializationSchema)o;
        CsvSchema otherSchema = that.csvSchema;
        return this.rowType.equals((Object)that.rowType) && this.csvSchema.getColumnSeparator() == otherSchema.getColumnSeparator() && Arrays.equals(this.csvSchema.getLineSeparator(), otherSchema.getLineSeparator()) && this.csvSchema.getArrayElementSeparator().equals(otherSchema.getArrayElementSeparator()) && this.csvSchema.getQuoteChar() == otherSchema.getQuoteChar() && this.csvSchema.getEscapeChar() == otherSchema.getEscapeChar() && Arrays.equals(this.csvSchema.getNullValue(), otherSchema.getNullValue());
    }

    public int hashCode() {
        return Objects.hash(this.rowType, Character.valueOf(this.csvSchema.getColumnSeparator()), this.csvSchema.getLineSeparator(), this.csvSchema.getArrayElementSeparator(), this.csvSchema.getQuoteChar(), this.csvSchema.getEscapeChar(), this.csvSchema.getNullValue());
    }

    @PublicEvolving
    public static class Builder {
        private final RowType rowType;
        private CsvSchema csvSchema;

        public Builder(RowType rowType) {
            Preconditions.checkNotNull((Object)rowType, (String)"Row type must not be null.");
            this.rowType = rowType;
            this.csvSchema = CsvRowSchemaConverter.convert(rowType);
        }

        public Builder setFieldDelimiter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setColumnSeparator(c).build();
            return this;
        }

        public Builder setArrayElementDelimiter(String delimiter) {
            Preconditions.checkNotNull((Object)delimiter, (String)"Delimiter must not be null.");
            this.csvSchema = this.csvSchema.rebuild().setArrayElementSeparator(delimiter).build();
            return this;
        }

        public Builder disableQuoteCharacter() {
            this.csvSchema = this.csvSchema.rebuild().disableQuoteChar().build();
            return this;
        }

        public Builder setQuoteCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setQuoteChar(c).build();
            return this;
        }

        public Builder setEscapeCharacter(char c) {
            this.csvSchema = this.csvSchema.rebuild().setEscapeChar(c).build();
            return this;
        }

        public Builder setNullLiteral(String s2) {
            this.csvSchema = this.csvSchema.rebuild().setNullValue(s2).build();
            return this;
        }

        public CsvRowDataSerializationSchema build() {
            return new CsvRowDataSerializationSchema(this.rowType, this.csvSchema);
        }
    }
}

