/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consume;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumeProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.ConsumeApproveForm;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.listener.consume.OperateConsumeTaskListener;
import org.apache.inlong.manager.service.listener.consume.apply.ApproveConsumeProcessListener;
import org.apache.inlong.manager.service.listener.consume.apply.CancelConsumeProcessListener;
import org.apache.inlong.manager.service.listener.consume.apply.RejectConsumeProcessListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.consume.ApplyConsumeProcessHandler;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ProcessDetailHandler;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplyConsumeWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private CancelConsumeProcessListener cancelConsumeProcessListener;
    @Autowired
    private RejectConsumeProcessListener rejectConsumeProcessListener;
    @Autowired
    private ApproveConsumeProcessListener approveConsumeProcessListener;
    @Autowired
    private OperateConsumeTaskListener operateConsumeTaskListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    @Autowired
    private ApplyConsumeProcessHandler applyConsumeProcessHandler;
    @Autowired
    private InlongGroupService groupService;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(ApplyConsumeProcessForm.class);
        process.setVersion(1);
        process.setProcessDetailHandler((ProcessDetailHandler)this.applyConsumeProcessHandler);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask groupOwnerUserTask = new UserTask();
        groupOwnerUserTask.setName("ut_group_owner");
        groupOwnerUserTask.setDisplayName("GroupApproval");
        groupOwnerUserTask.setApproverAssign(this::groupOwnerUserTaskApprover);
        process.addTask((WorkflowTask)groupOwnerUserTask);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("SystemAdmin");
        adminUserTask.setFormClass(ConsumeApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.operateConsumeTaskListener);
        process.addTask((WorkflowTask)adminUserTask);
        startEvent.addNext((Element)groupOwnerUserTask);
        groupOwnerUserTask.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        process.addListener((ProcessEventListener)this.approveConsumeProcessListener);
        process.addListener((ProcessEventListener)this.rejectConsumeProcessListener);
        process.addListener((ProcessEventListener)this.cancelConsumeProcessListener);
        return process;
    }

    private List<String> groupOwnerUserTaskApprover(WorkflowContext context) {
        ApplyConsumeProcessForm form = (ApplyConsumeProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(form.getConsumeInfo().getInlongGroupId());
        if (groupInfo == null || groupInfo.getInCharges() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(groupInfo.getInCharges().split(","));
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.APPLY_CONSUME_PROCESS;
    }

    private List<String> getTaskApprovers(String taskName) {
        return this.workflowApproverService.getApprovers(this.getProcessName().name(), taskName);
    }
}

