/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.tenant;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.InlongTenantEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.entity.TenantClusterTagEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongConsumeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongTenantEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantClusterTagEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantPageRequest;
import org.apache.inlong.manager.pojo.tenant.InlongTenantRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.ApproverRequest;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.tenant.InlongTenantService;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongTenantServiceImpl
implements InlongTenantService {
    private static final Logger log = LoggerFactory.getLogger(InlongTenantServiceImpl.class);
    @Autowired
    private InlongTenantEntityMapper inlongTenantEntityMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private StreamSinkEntityMapper sinkMapper;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeEntityMapper;
    @Autowired
    private InlongConsumeEntityMapper consumeEntityMapper;
    @Autowired
    private TenantClusterTagEntityMapper tenantClusterTagMapper;
    @Autowired
    private TenantRoleService tenantRoleService;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    private ExecutorService executorService = new ScheduledThreadPoolExecutor(1);

    @Override
    public InlongTenantInfo getByName(String name) {
        InlongTenantEntity entity = this.inlongTenantEntityMapper.selectByName(name);
        if (entity == null) {
            log.warn("not found valid inlong tenant by name={}", (Object)name);
            return null;
        }
        return (InlongTenantInfo)CommonBeanUtils.copyProperties((Object)entity, InlongTenantInfo::new);
    }

    @Override
    public Integer save(InlongTenantRequest request) {
        String name = request.getName();
        InlongTenantEntity existEntity = this.inlongTenantEntityMapper.selectByName(name);
        if (existEntity != null) {
            String errMsg = String.format("tenant already exist for name=%s)", name);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongTenantEntity entity = (InlongTenantEntity)CommonBeanUtils.copyProperties((Object)request, InlongTenantEntity::new);
        String operator = LoginUserUtils.getLoginUser().getName();
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.inlongTenantEntityMapper.insert(entity);
        UserInfo loginUserInfo = LoginUserUtils.getLoginUser();
        this.executorService.submit(() -> {
            loginUserInfo.setTenant(request.getName());
            LoginUserUtils.setUserLoginInfo((UserInfo)loginUserInfo);
            this.saveDefaultWorkflowApprovers(ProcessName.APPLY_GROUP_PROCESS.name(), "ut_admin", operator);
            this.saveDefaultWorkflowApprovers(ProcessName.APPLY_CONSUME_PROCESS.name(), "ut_admin", operator);
            LoginUserUtils.removeUserLoginInfo();
        });
        return entity.getId();
    }

    private Integer saveDefaultWorkflowApprovers(String processName, String taskName, String approver) {
        ApproverRequest request = new ApproverRequest();
        request.setProcessName(processName);
        request.setApprovers(approver);
        request.setTaskName(taskName);
        return this.workflowApproverService.save(request, approver);
    }

    @Override
    public PageResult<InlongTenantInfo> listByCondition(InlongTenantPageRequest request, UserInfo userInfo) {
        if (request.getListByLoginUser().booleanValue()) {
            this.setTargetTenantList(request, userInfo);
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = this.inlongTenantEntityMapper.selectByCondition(request);
        return PageResult.fromPage((Page)entityPage).map(entity -> (InlongTenantInfo)CommonBeanUtils.copyProperties((Object)entity, InlongTenantInfo::new));
    }

    @Override
    public Boolean update(InlongTenantRequest request) {
        InlongTenantEntity exist = this.inlongTenantEntityMapper.selectByName(request.getName());
        if (exist == null) {
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND, String.format("tenant record not found by name=%s", request.getName()));
        }
        if (!exist.getId().equals(request.getId())) {
            throw new BusinessException(ErrorCodeEnum.RECORD_DUPLICATE, String.format("tenant already exist for name=%s, required id=%s, exist id=%s", request.getName(), request.getId(), exist.getId()));
        }
        InlongTenantEntity entity = (InlongTenantEntity)CommonBeanUtils.copyProperties((Object)request, InlongTenantEntity::new);
        String operator = LoginUserUtils.getLoginUser().getName();
        entity.setModifier(operator);
        int rowCount = this.inlongTenantEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("failure to update tenant with name=%s, request version=%d, updated row=%d", request.getName(), request.getVersion(), rowCount));
        }
        return true;
    }

    @Override
    public Boolean delete(String name) {
        String operator = LoginUserUtils.getLoginUser().getName();
        log.info("begin to delete inlong tenant name={} by user={}", (Object)name, (Object)operator);
        InlongTenantEntity inlongTenantEntity = this.inlongTenantEntityMapper.selectByName(name);
        List groups = this.groupMapper.selectAllGroupsByTenant(name);
        List notStopGroups = groups.stream().filter(group -> !GroupStatus.CONFIG_DELETED.getCode().equals(group.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notStopGroups)) {
            List notStopGroupNames = notStopGroups.stream().map(InlongGroupEntity::getName).collect(Collectors.toList());
            String errMsg = String.format("delete inlong tenant name=[%s] failed, the tenant's group=%s are not in stop status", name, notStopGroupNames);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        List groupIds = groups.stream().map(InlongGroupEntity::getInlongGroupId).collect(Collectors.toList());
        List sourceList = this.sourceMapper.selectByGroupIds(groupIds);
        List noDisabledSources = sourceList.stream().filter(source -> !SourceStatus.SOURCE_DISABLE.getCode().equals(source.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(noDisabledSources)) {
            List noDisabledSourceNames = noDisabledSources.stream().map(StreamSourceEntity::getSourceName).collect(Collectors.toList());
            String errMsg = String.format("delete inlong tenant name=[%s] failed, the streamSource=%s of the tenant's groups are not in status 99", name, noDisabledSourceNames);
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        int success = this.inlongTenantEntityMapper.deleteById(inlongTenantEntity.getId());
        Preconditions.expectTrue((success == InlongConstants.AFFECTED_ONE_ROW ? 1 : 0) != 0, (String)"delete failed");
        log.info("success delete inlong tenant name={} by user={}", (Object)name, (Object)operator);
        return true;
    }

    @Override
    public Boolean migrate(String groupId, String to) {
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        Preconditions.expectTrue((boolean)this.hasPermission(userInfo, to), (String)String.format("user=[%s] has no permission to tenant=[%s]", userInfo.getName(), to));
        return this.doMigrate(groupId, userInfo.getTenant(), to);
    }

    public Boolean doMigrate(String groupId, String from, String to) {
        InlongGroupEntity group = this.groupMapper.selectByGroupId(groupId);
        Preconditions.expectNotNull((Object)group, (String)String.format("Not find group=%s in tenant=%s", groupId, from));
        List streamList = this.streamMapper.selectByGroupId(groupId);
        boolean streamMigrateResult = streamList.stream().allMatch(stream -> this.migrateStream((InlongStreamEntity)stream, from, to));
        log.info("migrate stream from source tenant={} to target tenant={} for groupId={}, result={}", new Object[]{from, to, groupId, streamMigrateResult});
        List consumeList = this.consumeEntityMapper.selectByGroupId(groupId);
        boolean consumeMigrateResult = this.migrateConsume(groupId, from, to, consumeList.size());
        boolean tagCopyResult = this.copyTenantTag(group.getInlongClusterTag(), from, to);
        boolean groupMigrateResult = this.migrateGroup(groupId, from, to);
        boolean migrateResult = streamMigrateResult && consumeMigrateResult && tagCopyResult && groupMigrateResult;
        log.info("migrate from source tenant={} to target tenant={} for groupId={}, result={}", new Object[]{from, to, groupId, migrateResult});
        return migrateResult;
    }

    public Boolean migrateStream(InlongStreamEntity stream, String from, String to) {
        List sinks = this.sinkMapper.selectByRelatedId(stream.getInlongGroupId(), stream.getInlongStreamId());
        List sources = this.sourceMapper.selectByRelatedId(stream.getInlongGroupId(), stream.getInlongStreamId(), null);
        boolean sinkMigrateResult = sinks.stream().allMatch(sink -> this.migrateStreamSink((StreamSinkEntity)sink, from, to));
        boolean sourceMigrateResult = sources.stream().allMatch(source -> this.migrateStreamSource((StreamSourceEntity)source, from, to));
        return sinkMigrateResult && sourceMigrateResult;
    }

    public Boolean migrateStreamSink(StreamSinkEntity sink, String from, String to) {
        String type;
        String dataNodeName = sink.getDataNodeName();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataNodeName, type = sink.getSinkType()})) {
            return true;
        }
        DataNodeEntity dataNode = this.dataNodeEntityMapper.selectByUniqueKey(dataNodeName, type);
        if (dataNode == null) {
            return true;
        }
        String newName = this.copyDataNode(dataNodeName, type, from, to);
        sink.setDataNodeName(newName);
        if (StringUtils.isNotBlank((CharSequence)sink.getSortTaskName())) {
            sink.setSortTaskName(newName);
        }
        return this.sinkMapper.updateByIdSelective(sink) == InlongConstants.AFFECTED_ONE_ROW.intValue();
    }

    public Boolean migrateStreamSource(StreamSourceEntity source, String from, String to) {
        String type;
        String dataNodeName = source.getDataNodeName();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dataNodeName, type = source.getSourceType()})) {
            return true;
        }
        DataNodeEntity dataNode = this.dataNodeEntityMapper.selectByUniqueKey(dataNodeName, type);
        if (dataNode == null) {
            return true;
        }
        String newName = this.copyDataNode(dataNodeName, type, from, to);
        source.setDataNodeName(newName);
        return this.sourceMapper.updateByPrimaryKeySelective(source) == InlongConstants.AFFECTED_ONE_ROW.intValue();
    }

    public String copyDataNode(String name, String type, String from, String to) {
        DataNodeEntity oldDatanode = this.dataNodeEntityMapper.selectByUniqueKey(name, type);
        oldDatanode.setTenant(to);
        List newDatanodeList = this.dataNodeEntityMapper.selectByIdSelective(oldDatanode);
        if (CollectionUtils.isNotEmpty((Collection)newDatanodeList)) {
            return ((DataNodeEntity)newDatanodeList.get(0)).getName();
        }
        String newName = UUID.randomUUID().toString();
        if (this.dataNodeEntityMapper.copy(name, type, from, to, newName) != InlongConstants.AFFECTED_ONE_ROW.intValue()) {
            return null;
        }
        return newName;
    }

    public Boolean migrateConsume(String groupId, String from, String to, int size) {
        Boolean result = this.consumeEntityMapper.migrate(groupId, from, to) == size;
        log.info("migrate consume from source tenant={} to target tenant={} for groupId={}, result={}", new Object[]{from, to, groupId, result});
        return result;
    }

    public Boolean migrateGroup(String groupId, String from, String to) {
        Boolean result = this.groupMapper.migrate(groupId, from, to) == InlongConstants.AFFECTED_ONE_ROW.intValue();
        log.info("migrate group from source tenant={} to target tenant={} for groupId={}, result={}", new Object[]{from, to, groupId, result});
        return result;
    }

    public Boolean copyTenantTag(String clusterTag, String from, String to) {
        try {
            TenantClusterTagEntity existEntity = this.tenantClusterTagMapper.selectByUniqueKey(clusterTag, to);
            if (existEntity != null) {
                log.debug("tag name={} in tenant={} already exist", (Object)clusterTag, (Object)to);
                return true;
            }
            this.tenantClusterTagMapper.copy(clusterTag, from, to);
            return true;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                log.debug("tag name={} in tenant={} already exist", (Object)clusterTag, (Object)to);
                return true;
            }
            throw e;
        }
    }

    private boolean hasPermission(UserInfo userInfo, String tenant) {
        return this.tenantRoleService.getByUsernameAndTenant(userInfo.getName(), tenant) != null || this.isInlongRoles(userInfo);
    }

    public void setTargetTenantList(InlongTenantPageRequest request, UserInfo userInfo) {
        if (this.isInlongRoles(userInfo)) {
            request.setTenantList(null);
            return;
        }
        List<String> tenants = this.tenantRoleService.listTenantByUsername(userInfo.getName());
        if (CollectionUtils.isEmpty(tenants)) {
            String errMsg = String.format("user=[%s] doesn't belong to any tenant, please contact administrator and get one tenant at least", userInfo.getName());
            log.error(errMsg);
            throw new BusinessException(errMsg);
        }
        request.setTenantList(tenants);
    }

    private boolean isInlongRoles(UserInfo userInfo) {
        return userInfo.getRoles().contains("INLONG_ADMIN") || userInfo.getRoles().contains("INLONG_OPERATOR");
    }
}

