/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.datatype;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.pojo.sort.dataflow.dataType.CsvConfig;
import org.apache.inlong.common.pojo.sort.dataflow.dataType.DataTypeConfig;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.SourceDecoderFactory;
import org.apache.inlong.sdk.transform.decode.SplitUtils;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.encode.SinkEncoderFactory;
import org.apache.inlong.sdk.transform.pojo.CsvSourceInfo;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.MapSinkInfo;
import org.apache.inlong.sdk.transform.pojo.TransformConfig;
import org.apache.inlong.sdk.transform.process.TransformProcessor;
import org.apache.inlong.sdk.transform.process.converter.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsvDataTypeOperator
implements DataTypeOperator {
    private static final Logger log = LoggerFactory.getLogger(CsvDataTypeOperator.class);

    @Override
    public boolean accept(DataTypeEnum type) {
        return DataTypeEnum.CSV.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage.FieldInfo> parseFields(String str, InlongStreamInfo streamInfo) throws Exception {
        List fields = CommonBeanUtils.copyListProperties((List)streamInfo.getFieldList(), BriefMQMessage.FieldInfo::new);
        try {
            char separator = '|';
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
                separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
            }
            Character escapeChar = null;
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataEscapeChar())) {
                escapeChar = Character.valueOf(streamInfo.getDataEscapeChar().charAt(0));
            }
            String[][] rowValues = SplitUtils.splitCsv((String)str, (Character)Character.valueOf(separator), (Character)escapeChar, null, null, (boolean)true);
            int fieldIndex = 0;
            for (int i = 0; i < rowValues.length; ++i) {
                String[] fieldValues = rowValues[i];
                for (int j = 0; j < fieldValues.length; ++j) {
                    if (i + j >= fields.size()) continue;
                    ((BriefMQMessage.FieldInfo)fields.get(fieldIndex++)).setFieldValue(fieldValues[j]);
                }
            }
        }
        catch (Exception e) {
            log.warn("parse fields failed for groupId = {}, streamId = {}", new Object[]{streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId(), e});
        }
        return fields;
    }

    @Override
    public DataTypeConfig getDataTypeConfig(InlongStreamInfo streamInfo) {
        char separator = '\u0000';
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
            separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
        }
        Character escape = null;
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataEscapeChar())) {
            escape = Character.valueOf(streamInfo.getDataEscapeChar().charAt(0));
        }
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setDelimiter(Character.valueOf(separator));
        csvConfig.setEscapeChar(escape);
        return csvConfig;
    }

    @Override
    public Map<String, Object> parseTransform(InlongStreamInfo streamInfo, List<SinkField> fieldList, String transformSql, String data) {
        try {
            ArrayList<FieldInfo> srcFields = new ArrayList<FieldInfo>();
            ArrayList<FieldInfo> dstFields = new ArrayList<FieldInfo>();
            for (StreamField streamField : streamInfo.getFieldList()) {
                if (!StringUtils.isNotBlank((CharSequence)streamField.getFieldName())) continue;
                srcFields.add(new FieldInfo(streamField.getFieldName(), TypeConverter.DefaultTypeConverter()));
            }
            for (SinkField sinkField : fieldList) {
                String targetFieldName = sinkField.getFieldName();
                if (!StringUtils.isNotBlank((CharSequence)targetFieldName)) continue;
                dstFields.add(new FieldInfo(targetFieldName));
            }
            char separator = '&';
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
                separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
            }
            Character escape = null;
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataEscapeChar())) {
                escape = Character.valueOf(streamInfo.getDataEscapeChar().charAt(0));
            }
            CsvSourceInfo csvSource = new CsvSourceInfo(streamInfo.getDataEncoding(), Character.valueOf(separator), escape, srcFields);
            MapSinkInfo mapSinkInfo = new MapSinkInfo(streamInfo.getDataEncoding(), dstFields);
            TransformConfig config = new TransformConfig(transformSql);
            TransformProcessor processor = TransformProcessor.create((TransformConfig)config, (SourceDecoder)SourceDecoderFactory.createCsvDecoder((CsvSourceInfo)csvSource), (SinkEncoder)SinkEncoderFactory.createMapEncoder((MapSinkInfo)mapSinkInfo));
            List result = processor.transform((Object)data);
            log.info("success parse transform sql result={}", (Object)result);
            return (Map)result.get(0);
        }
        catch (Exception e) {
            log.error("parse transform sql failed", (Throwable)e);
            throw new BusinessException("parse transform sql failed" + e.getMessage());
        }
    }
}

