/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster.node;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.agent.AgentResponseCode;
import org.apache.inlong.common.pojo.agent.installer.ConfigRequest;
import org.apache.inlong.common.pojo.agent.installer.ConfigResult;
import org.apache.inlong.common.pojo.agent.installer.ModuleConfig;
import org.apache.inlong.common.pojo.agent.installer.PackageConfig;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ModuleType;
import org.apache.inlong.manager.common.enums.NodeStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.AgentTaskConfigEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.entity.ModuleConfigEntity;
import org.apache.inlong.manager.dao.entity.PackageConfigEntity;
import org.apache.inlong.manager.dao.mapper.AgentTaskConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.ModuleConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.PackageConfigEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeDTO;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeResponse;
import org.apache.inlong.manager.pojo.module.ModuleDTO;
import org.apache.inlong.manager.service.cluster.node.AbstractClusterNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgentClusterNodeOperator
extends AbstractClusterNodeOperator {
    private static final Logger log = LoggerFactory.getLogger(AgentClusterNodeOperator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentClusterNodeOperator.class);
    private static final Gson GSON = new Gson();
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private AgentTaskConfigEntityMapper agentTaskConfigEntityMapper;
    @Autowired
    private PackageConfigEntityMapper packageConfigEntityMapper;
    @Autowired
    private ModuleConfigEntityMapper moduleConfigEntityMapper;

    @Override
    public Boolean accept(String clusterNodeType) {
        return this.getClusterNodeType().equals(clusterNodeType);
    }

    @Override
    public String getClusterNodeType() {
        return "AGENT";
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(ClusterNodeRequest request, String operator) {
        InlongClusterNodeEntity entity = (InlongClusterNodeEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterNodeEntity::new);
        this.setTargetEntity(request, entity);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setStatus(Integer.valueOf(NodeStatus.HEARTBEAT_TIMEOUT.getStatus()));
        this.clusterNodeMapper.insert(entity);
        InlongClusterEntity clusterEntity = this.clusterMapper.selectById(request.getParentId());
        String clusterName = clusterEntity.getName();
        String ip = request.getIp();
        this.updateModuleConfig(ip, clusterName);
        return entity.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(ClusterNodeRequest request, String operator) {
        InlongClusterNodeEntity entity = this.clusterNodeMapper.selectById(request.getId());
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterNodeMapper.updateByIdSelective(entity)) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("cluster node has already updated with ip=%s, port=%s, protocolType=%s, type=%s, curVersion=%s", entity.getIp(), entity.getPort(), entity.getProtocolType(), entity.getType(), entity.getVersion()));
        }
        InlongClusterEntity clusterEntity = this.clusterMapper.selectById(request.getParentId());
        String clusterName = clusterEntity.getName();
        String ip = request.getIp();
        this.updateModuleConfig(ip, clusterName);
        LOGGER.debug("success to update inlong cluster node={}", (Object)request);
    }

    @Override
    public ClusterNodeResponse getFromEntity(InlongClusterNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        AgentClusterNodeResponse agentClusterNodeResponse = new AgentClusterNodeResponse();
        CommonBeanUtils.copyProperties((Object)entity, (Object)agentClusterNodeResponse);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)agentClusterNodeResponse);
        }
        LOGGER.debug("success to get agent cluster node info from entity");
        return agentClusterNodeResponse;
    }

    @Override
    protected void setTargetEntity(ClusterNodeRequest request, InlongClusterNodeEntity targetEntity) {
        AgentClusterNodeRequest agentNodeRequest = (AgentClusterNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)agentNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromRequest((AgentClusterNodeRequest)agentNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for agent cluster node");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Agent ClusterNode failure: %s", e.getMessage()));
        }
    }

    public void updateModuleConfig(String ip, String clusterName) {
        try {
            if (StringUtils.isBlank((CharSequence)clusterName) || StringUtils.isBlank((CharSequence)ip)) {
                LOGGER.info("no need to update module config when ip or cluster name is null");
                return;
            }
            ConfigRequest configRequest = new ConfigRequest();
            LOGGER.info("begin to update module config for cluster name={}, ip={}", (Object)clusterName, (Object)ip);
            configRequest.setLocalIp(ip);
            configRequest.setClusterName(clusterName);
            ConfigResult configResult = this.loadModuleConfigs(configRequest);
            AgentTaskConfigEntity existEntity = this.agentTaskConfigEntityMapper.selectByIdentifier(ip, clusterName);
            AgentTaskConfigEntity agentTaskConfigEntity = existEntity == null ? new AgentTaskConfigEntity() : (AgentTaskConfigEntity)CommonBeanUtils.copyProperties((Object)existEntity, AgentTaskConfigEntity::new, (boolean)true);
            agentTaskConfigEntity.setAgentIp(ip);
            agentTaskConfigEntity.setClusterName(clusterName);
            agentTaskConfigEntity.setModuleParams(this.objectMapper.writeValueAsString((Object)configResult));
            if (existEntity == null) {
                this.agentTaskConfigEntityMapper.insert(agentTaskConfigEntity);
            } else {
                this.agentTaskConfigEntityMapper.updateByIdSelective(agentTaskConfigEntity);
            }
            LOGGER.info("success to update module config for cluster name={}, ip={}", (Object)clusterName, (Object)ip);
        }
        catch (Exception e) {
            LOGGER.error("load module config failed", (Throwable)e);
            throw new BusinessException("load module config faield");
        }
    }

    private ConfigResult loadModuleConfigs(ConfigRequest request) {
        List clusterNodeEntityList;
        String clusterName = request.getClusterName();
        String ip = request.getLocalIp();
        LOGGER.debug("begin to load config for installer = {}", (Object)request);
        Preconditions.expectTrue((boolean)StringUtils.isNotBlank((CharSequence)clusterName), (String)"cluster name is blank");
        InlongClusterEntity clusterEntity = this.clusterMapper.selectByNameAndType(clusterName, "AGENT");
        List<Object> configs = new ArrayList();
        if (clusterEntity != null && CollectionUtils.isNotEmpty((Collection)(clusterNodeEntityList = this.clusterNodeMapper.selectByParentIdAndIp(clusterEntity.getId(), ip)))) {
            AgentClusterNodeDTO dto = AgentClusterNodeDTO.getFromJson((String)((InlongClusterNodeEntity)clusterNodeEntityList.get(0)).getExtParams());
            configs = this.getModuleConfigs(dto);
        }
        String jsonStr = GSON.toJson(configs);
        String configMd5 = DigestUtils.md5Hex((String)jsonStr);
        ConfigResult configResult = ConfigResult.builder().moduleList(configs).md5(configMd5).code(AgentResponseCode.SUCCESS).build();
        LOGGER.info("success load module config, size = {}", (Object)configResult.getModuleList().size());
        return configResult;
    }

    private List<ModuleConfig> getModuleConfigs(AgentClusterNodeDTO dto) {
        List moduleIdList = dto.getModuleIdList();
        ArrayList<ModuleConfig> configs = new ArrayList<ModuleConfig>();
        if (CollectionUtils.isEmpty((Collection)moduleIdList)) {
            return configs;
        }
        for (Integer moduleId : moduleIdList) {
            ModuleConfigEntity moduleConfigEntity = this.moduleConfigEntityMapper.selectByPrimaryKey(moduleId);
            if (moduleConfigEntity == null) continue;
            ModuleConfig moduleConfig = (ModuleConfig)CommonBeanUtils.copyProperties((Object)moduleConfigEntity, ModuleConfig::new);
            moduleConfig.setId(Integer.valueOf(ModuleType.forType((String)moduleConfigEntity.getType()).getModuleId()));
            moduleConfig.setEntityId(moduleConfigEntity.getId());
            PackageConfigEntity packageConfigEntity = this.packageConfigEntityMapper.selectByPrimaryKey(moduleConfigEntity.getPackageId());
            moduleConfig.setPackageConfig((PackageConfig)CommonBeanUtils.copyProperties((Object)packageConfigEntity, PackageConfig::new));
            ModuleDTO moduleDTO = (ModuleDTO)JsonUtils.parseObject((String)moduleConfigEntity.getExtParams(), ModuleDTO.class);
            moduleConfig = (ModuleConfig)CommonBeanUtils.copyProperties((Object)moduleDTO, (Object)moduleConfig, (boolean)true);
            Integer restartTime = 0;
            if (Objects.equals(moduleConfigEntity.getType(), ModuleType.AGENT.name())) {
                restartTime = dto.getAgentRestartTime();
            }
            if (Objects.equals(moduleConfigEntity.getType(), ModuleType.INSTALLER.name())) {
                restartTime = dto.getInstallRestartTime();
            }
            moduleConfig.setRestartTime(restartTime);
            moduleConfig.setProcessesNum(Integer.valueOf(1));
            String moduleStr = GSON.toJson((Object)moduleConfig);
            String moduleMd5 = DigestUtils.md5Hex((String)moduleStr);
            moduleConfig.setMd5(moduleMd5);
            configs.add(moduleConfig);
        }
        return configs;
    }
}

