/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantRoleClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSinkClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSourceClient;
import org.apache.inlong.manager.client.api.inner.client.StreamTransformClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.pojo.ClusterInfo;
import org.apache.inlong.manager.client.cli.pojo.ClusterNodeInfo;
import org.apache.inlong.manager.client.cli.pojo.ClusterTagInfo;
import org.apache.inlong.manager.client.cli.pojo.GroupInfo;
import org.apache.inlong.manager.client.cli.pojo.SinkInfo;
import org.apache.inlong.manager.client.cli.pojo.SourceInfo;
import org.apache.inlong.manager.client.cli.pojo.StreamInfo;
import org.apache.inlong.manager.client.cli.pojo.TenantInfo;
import org.apache.inlong.manager.client.cli.pojo.TenantRoleInfo;
import org.apache.inlong.manager.client.cli.pojo.TransformInfo;
import org.apache.inlong.manager.client.cli.pojo.UserInfo;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.client.cli.util.PrintUtils;
import org.apache.inlong.manager.client.cli.validator.ClusterTypeValidator;
import org.apache.inlong.manager.client.cli.validator.UserTypeValidator;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.tenant.InlongTenantPageRequest;
import org.apache.inlong.manager.pojo.user.TenantRolePageRequest;
import org.apache.inlong.manager.pojo.user.UserRequest;

@Parameters(commandDescription="Displays summary information about one or more resources")
public class ListCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public ListCommand() {
        super("list");
        this.jcommander.addCommand("stream", (Object)new ListStream());
        this.jcommander.addCommand("group", (Object)new ListGroup());
        this.jcommander.addCommand("sink", (Object)new ListSink());
        this.jcommander.addCommand("source", (Object)new ListSource());
        this.jcommander.addCommand("transform", (Object)new ListTransform());
        this.jcommander.addCommand("cluster", (Object)new ListCluster());
        this.jcommander.addCommand("cluster-tag", (Object)new ListClusterTag());
        this.jcommander.addCommand("cluster-node", (Object)new ListClusterNode());
        this.jcommander.addCommand("user", (Object)new ListUser());
        this.jcommander.addCommand("tenant", (Object)new ListTenant());
        this.jcommander.addCommand("tenant-role", (Object)new ListTenantRole());
    }

    @Parameters(commandDescription="Get tenant role summary information")
    private static class ListTenantRole
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-keyword", "--keyword"}, description="keyword")
        private String keyword;

        private ListTenantRole() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                TenantRolePageRequest request = new TenantRolePageRequest();
                request.setKeyword(this.keyword);
                InlongTenantRoleClient tenantRoleClient = ClientUtils.clientFactory.getInlongTenantRoleClient();
                PageResult tenantInfo = tenantRoleClient.listByCondition(request);
                PrintUtils.print(tenantInfo.getList(), TenantRoleInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get tenant summary information")
    private static class ListTenant
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-keyword", "--keyword"}, description="keyword")
        private String keyword;

        private ListTenant() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongTenantPageRequest request = new InlongTenantPageRequest();
                request.setKeyword(this.keyword);
                InlongTenantClient tenantClient = ClientUtils.clientFactory.getInlongTenantClient();
                PageResult tenantInfo = tenantClient.listByCondition(request);
                PrintUtils.print(tenantInfo.getList(), TenantInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get user summary information")
    private static class ListUser
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-u", "--username"}, description="username")
        private String username;
        @Parameter(names={"--type"}, description="user type", validateWith={UserTypeValidator.class})
        private String type;

        private ListUser() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                UserRequest request = new UserRequest();
                Integer integer = TenantUserTypeEnum.parseName((String)this.type);
                request.setAccountType(integer);
                request.setKeyword(this.username);
                UserClient userClient = ClientUtils.clientFactory.getUserClient();
                PageResult userInfo = userClient.list(request);
                PrintUtils.print(userInfo.getList(), UserInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster node summary information")
    private static class ListClusterNode
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--tag"}, description="cluster tag")
        private String tag;
        @Parameter(names={"--type"}, description="cluster type")
        private String type;

        private ListClusterNode() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                ClusterPageRequest request = new ClusterPageRequest();
                request.setClusterTag(this.tag);
                request.setType(this.type);
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                PageResult nodeInfo = clusterClient.listNode(request);
                PrintUtils.print(nodeInfo.getList(), ClusterNodeInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster tag summary information")
    private static class ListClusterTag
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--tag"}, description="cluster tag")
        private String tag;

        private ListClusterTag() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                ClusterTagPageRequest request = new ClusterTagPageRequest();
                request.setKeyword(this.tag);
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                PageResult tagInfo = clusterClient.listTag(request);
                PrintUtils.print(tagInfo.getList(), ClusterTagInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster summary information")
    private static class ListCluster
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--type"}, description="cluster type", validateWith={ClusterTypeValidator.class})
        private String type;
        @Parameter(names={"--tag"}, description="cluster tag")
        private String tag;

        private ListCluster() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                ClusterPageRequest request = new ClusterPageRequest();
                request.setType(this.type);
                request.setClusterTag(this.tag);
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                PageResult clusterInfo = clusterClient.list(request);
                PrintUtils.print(clusterInfo.getList(), ClusterInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get transform summary information")
    private static class ListTransform
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--stream"}, required=true, description="inlong stream id")
        private String streamId;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String groupId;

        private ListTransform() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamTransformClient transformClient = ClientUtils.clientFactory.getTransformClient();
                List transformResponses = transformClient.listTransform(this.groupId, this.streamId).getList();
                PrintUtils.print(transformResponses, TransformInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get source summary information")
    private static class ListSource
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--stream"}, required=true, description="inlong stream id")
        private String stream;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String group;
        @Parameter(names={"-t", "--type"}, description="source type")
        private String type;

        private ListSource() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamSourceClient sourceClient = ClientUtils.clientFactory.getSourceClient();
                List streamSources = sourceClient.listSources(this.group, this.stream, this.type);
                PrintUtils.print(streamSources, SourceInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get sink summary information")
    private static class ListSink
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--stream"}, required=true, description="stream id")
        private String stream;
        @Parameter(names={"-g", "--group"}, required=true, description="group id")
        private String group;

        private ListSink() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamSinkClient sinkClient = ClientUtils.clientFactory.getSinkClient();
                List streamSinks = sinkClient.listSinks(this.group, this.stream);
                PrintUtils.print(streamSinks, SinkInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get group summary information")
    private static class ListGroup
    extends AbstractCommandRunner {
        private static final int DEFAULT_PAGE_SIZE = 10;
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--status"}, description="inlong group status")
        private String status;
        @Parameter(names={"-g", "--group"}, description="inlong group id")
        private String group;
        @Parameter(names={"-n", "--num"}, description="the number displayed")
        private int pageSize;

        private ListGroup() {
        }

        @Override
        void run() {
            try {
                InlongGroupPageRequest pageRequest = new InlongGroupPageRequest();
                pageRequest.setKeyword(this.group);
                this.pageSize = this.pageSize <= 0 ? 10 : this.pageSize;
                pageRequest.setPageNum(1).setPageSize(this.pageSize);
                this.status = this.status == null ? SimpleGroupStatus.STARTED.toString() : this.status;
                List statusList = SimpleGroupStatus.parseStatusCodeByStr((String)this.status);
                pageRequest.setStatusList(statusList);
                ClientUtils.initClientFactory();
                InlongGroupClient groupClient = ClientUtils.clientFactory.getGroupClient();
                PageResult groupPageInfo = groupClient.listGroups(pageRequest);
                PrintUtils.print(groupPageInfo.getList(), GroupInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get stream summary information")
    private static class ListStream
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String groupId;

        private ListStream() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongStreamClient streamClient = ClientUtils.clientFactory.getStreamClient();
                List streamInfos = streamClient.listStreamInfo(this.groupId);
                PrintUtils.print(streamInfos, StreamInfo.class);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

