/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.Configurable;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.enums.InlongCompressType;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.metrics.DataProxyMetricItem;
import org.apache.inlong.dataproxy.metrics.audit.AuditUtils;
import org.apache.inlong.dataproxy.sink.common.SinkContext;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfile;
import org.apache.inlong.dataproxy.sink.mq.CacheClusterSelector;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSink;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;

public class MessageQueueZoneSinkContext
extends SinkContext {
    public static final String KEY_NODE_ID = "nodeId";
    public static final String PREFIX_PRODUCER = "producer.";
    public static final String KEY_COMPRESS_TYPE = "compressType";
    private final MessageQueueZoneSink mqZoneSink;
    private final String proxyClusterId;
    private final String nodeId;
    private final Context producerContext;
    private final InlongCompressType compressType;

    public MessageQueueZoneSinkContext(MessageQueueZoneSink mqZoneSink, Context context, Channel channel) {
        super(mqZoneSink.getCachedSinkName(), context, channel);
        this.mqZoneSink = mqZoneSink;
        this.proxyClusterId = CommonConfigHolder.getInstance().getClusterName();
        this.nodeId = CommonConfigHolder.getInstance().getProxyNodeId();
        this.compressType = CommonConfigHolder.getInstance().getDefV1MsgCompressType();
        Map producerParams = context.getSubProperties(PREFIX_PRODUCER);
        this.producerContext = new Context(producerParams);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void close() {
        super.close();
    }

    public String getProxyClusterId() {
        return this.proxyClusterId;
    }

    public MessageQueueZoneSink getMqZoneSink() {
        return this.mqZoneSink;
    }

    public Context getProducerContext() {
        return this.producerContext;
    }

    public InlongCompressType getCompressType() {
        return this.compressType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void addSendResultMetric(PackProfile currentRecord, String mqName, String topic, boolean result, long sendTime) {
        if (currentRecord instanceof SimplePackProfile) {
            if (result) {
                AuditUtils.addOutputSuccess(((SimplePackProfile)currentRecord).getEvent());
            }
            return;
        }
        BatchPackProfile batchProfile = (BatchPackProfile)currentRecord;
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("clusterId", this.getProxyClusterId());
        dimensions.put("sourceId", "-");
        dimensions.put("sourceDataId", "-");
        MessageQueueZoneSinkContext.fillInlongId(batchProfile, dimensions);
        dimensions.put("sinkId", mqName);
        dimensions.put("sinkDataId", topic);
        long currentTime = System.currentTimeMillis();
        batchProfile.getEvents().forEach(event -> {
            long msgTime = event.getMsgTime();
            long auditFormatTime = msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
            dimensions.put("msgTime", String.valueOf(auditFormatTime));
            DataProxyMetricItem metricItem = (DataProxyMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
            if (result) {
                metricItem.sendSuccessCount.addAndGet(1L);
                metricItem.sendSuccessSize.addAndGet(event.getBody().length);
                if (sendTime > 0L) {
                    long sinkDuration = currentTime - sendTime;
                    long nodeDuration = currentTime - event.getSourceTime();
                    long wholeDuration = currentTime - msgTime;
                    metricItem.sinkDuration.addAndGet(sinkDuration);
                    metricItem.nodeDuration.addAndGet(nodeDuration);
                    metricItem.wholeDuration.addAndGet(wholeDuration);
                }
                AuditUtils.addOutputSuccess((Event)event);
            } else {
                metricItem.sendFailCount.addAndGet(1L);
                metricItem.sendFailSize.addAndGet(event.getBody().length);
            }
        });
    }

    public void addSendMetric(PackProfile currentRecord, String mqName, String topic, int sendPackSize) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("clusterId", this.getProxyClusterId());
        dimensions.put("sourceId", "-");
        dimensions.put("sourceDataId", "-");
        MessageQueueZoneSinkContext.fillInlongId(currentRecord, dimensions);
        dimensions.put("sinkId", mqName);
        dimensions.put("sinkDataId", topic);
        long msgTime = currentRecord.getDispatchTime();
        long auditFormatTime = msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        DataProxyMetricItem metricItem = (DataProxyMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
        long count = currentRecord.getCount();
        long size = currentRecord.getSize();
        metricItem.sendCount.addAndGet(count);
        metricItem.sendSize.addAndGet(size);
        metricItem.sendPackCount.incrementAndGet();
        metricItem.sendPackSize.addAndGet(sendPackSize);
    }

    public void addSendFailMetric() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("clusterId", this.getProxyClusterId());
        dimensions.put("sourceId", "-");
        dimensions.put("sourceDataId", "-");
        dimensions.put("inlongGroupId", "-");
        dimensions.put("inlongStreamId", "-");
        dimensions.put("sinkId", this.getSinkName());
        dimensions.put("sinkDataId", "-");
        long msgTime = System.currentTimeMillis();
        long auditFormatTime = msgTime - msgTime % CommonConfigHolder.getInstance().getAuditFormatInvlMs();
        dimensions.put("msgTime", String.valueOf(auditFormatTime));
        DataProxyMetricItem metricItem = (DataProxyMetricItem)this.getMetricItemSet().findMetricItem(dimensions);
        metricItem.sendFailCount.incrementAndGet();
        metricItem.sendFailSize.incrementAndGet();
    }

    public static void fillInlongId(PackProfile currentRecord, Map<String, String> dimensions) {
        String inlongGroupId = currentRecord.getInlongGroupId();
        inlongGroupId = StringUtils.isBlank((CharSequence)inlongGroupId) ? "-" : inlongGroupId;
        String inlongStreamId = currentRecord.getInlongStreamId();
        inlongStreamId = StringUtils.isBlank((CharSequence)inlongStreamId) ? "-" : inlongStreamId;
        dimensions.put("inlongGroupId", inlongGroupId);
        dimensions.put("inlongStreamId", inlongStreamId);
    }

    public void processSendFail(PackProfile currentRecord, String mqName, String topic, long sendTime, DataProxyErrCode errCode, String errMsg) {
        if (currentRecord.isResend()) {
            this.mqZoneSink.offerDispatchRecord(currentRecord);
            this.fileMetricIncSumStats("sink.retry");
            this.addSendResultMetric(currentRecord, mqName, topic, false, sendTime);
        } else {
            this.mqZoneSink.releaseAcquiredSizePermit(currentRecord);
            this.fileMetricIncSumStats("sink.dropped");
            currentRecord.fail(errCode, errMsg);
        }
    }

    public CacheClusterSelector createCacheClusterSelector() {
        String strSelectorClass = CommonConfigHolder.getInstance().getCacheClusterSelector();
        try {
            Class selectorClass = ClassUtils.getClass((String)strSelectorClass);
            Object selectorObject = selectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (selectorObject instanceof Configurable) {
                Configurable configurable = (Configurable)selectorObject;
                configurable.configure(new Context(CommonConfigHolder.getInstance().getProperties()));
            }
            if (selectorObject instanceof CacheClusterSelector) {
                return (CacheClusterSelector)selectorObject;
            }
        }
        catch (Throwable t) {
            logger.error("Fail to init CacheClusterSelector,selectorClass:{},error:{}", new Object[]{strSelectorClass, t.getMessage(), t});
        }
        return null;
    }
}

