/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_sort"}, parameter="(Array array[,Boolean ascending_order[,Boolean null_first]])", descriptions={"- Return \"\" if 'array' is null;", "- Return the array in sorted order.", "Note: The function sorts an array, defaulting to ascending order with NULLs at the start when only the array is input. Specifying 'ascending_order' as true orders the array in ascending with NULLs first, and setting it to false orders it in descending with NULLs last. Independently, 'null_first' as true moves NULLs to the beginning, and as false to the end, irrespective of the sorting order."}, examples={"array_sort(array('he',7,'xxd')) = [7, he, xxd]", "array_sort(array(3,7,5)) = [3, 5, 7]", "array_sort(array(,3,7),false,false) = [7, 3, ]", "array_sort(array(3,7,),true,false) = [3, 7, ]"})
public class ArraySortFunction
implements ValueParser {
    private ValueParser arrayParser;
    private ValueParser ascendingOrderParser;
    private ValueParser nullFirstParser;

    public ArraySortFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (!expressions.isEmpty()) {
            this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
            if (expressions.size() >= 2) {
                this.ascendingOrderParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
                if (expressions.size() >= 3) {
                    this.nullFirstParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(2));
                }
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        boolean nullFirst;
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object ascendingOrderObj = null;
        Object nullFirstObj = null;
        if (this.ascendingOrderParser != null) {
            ascendingOrderObj = this.ascendingOrderParser.parse(sourceData, rowIndex, context);
        }
        if (this.nullFirstParser != null) {
            nullFirstObj = this.nullFirstParser.parse(sourceData, rowIndex, context);
        }
        if (arrayObj == null) {
            return null;
        }
        boolean ascendingOrder = ascendingOrderObj == null || OperatorTools.parseBoolean(ascendingOrderObj);
        boolean bl = nullFirst = nullFirstObj == null || OperatorTools.parseBoolean(nullFirstObj);
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            return this.arraySort(array, ascendingOrder, nullFirst);
        }
        return null;
    }

    private List<Object> arraySort(List<Object> array, Boolean ascendingOrder, Boolean nullFirst) {
        if (array == null || ascendingOrder == null || nullFirst == null) {
            return null;
        }
        ArrayList<Object> nonNullElements = new ArrayList<Object>();
        ArrayList<Object> nullElements = new ArrayList<Object>();
        for (Object element : array) {
            if (element == null || element.equals("")) {
                nullElements.add(element);
                continue;
            }
            if (element instanceof Comparable) {
                nonNullElements.add(element);
                continue;
            }
            throw new IllegalArgumentException("Array contains non-comparable elements.");
        }
        if (ascendingOrder.booleanValue()) {
            Collections.sort(nonNullElements, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            });
        } else {
            Collections.sort(nonNullElements, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((Comparable)o2).compareTo(o1);
                }
            });
        }
        ArrayList<Object> sortedArray = new ArrayList<Object>();
        if (nullFirst.booleanValue()) {
            sortedArray.addAll(nullElements);
            sortedArray.addAll(nonNullElements);
        } else {
            sortedArray.addAll(nonNullElements);
            sortedArray.addAll(nullElements);
        }
        return sortedArray;
    }
}

