/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.ExistType;
import com.moilioncircle.redis.replicator.cmd.impl.Geo;
import com.moilioncircle.redis.replicator.cmd.impl.GeoAddCommand;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.ArrayList;

public class GeoAddParser
implements CommandParser<GeoAddCommand> {
    @Override
    public GeoAddCommand parse(Object[] command) {
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        ++idx;
        ArrayList<Geo> list = new ArrayList<Geo>();
        ExistType existType = ExistType.NONE;
        boolean ch = false;
        while (idx < command.length) {
            String token = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(token, "NX")) {
                existType = ExistType.NX;
            } else if (Strings.isEquals(token, "XX")) {
                existType = ExistType.XX;
            } else if (Strings.isEquals(token, "CH")) {
                ch = true;
            } else {
                double longitude = CommandParsers.toDouble(command[idx++]);
                double latitude = CommandParsers.toDouble(command[idx++]);
                byte[] member = CommandParsers.toBytes(command[idx]);
                list.add(new Geo(member, longitude, latitude));
            }
            ++idx;
        }
        Geo[] geos = new Geo[list.size()];
        list.toArray(geos);
        return new GeoAddCommand(key, geos, existType, ch);
    }
}

