/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.operations.SqlToOperationConverter;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.parse.ExtendedParser;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

public class ParserImpl
implements Parser {
    private final CatalogManager catalogManager;
    private final Supplier<FlinkPlannerImpl> validatorSupplier;
    private final Supplier<CalciteParser> calciteParserSupplier;
    private final SqlExprToRexConverterFactory sqlExprToRexConverterFactory;
    private static final ExtendedParser EXTENDED_PARSER = ExtendedParser.INSTANCE;

    public ParserImpl(CatalogManager catalogManager, Supplier<FlinkPlannerImpl> validatorSupplier, Supplier<CalciteParser> calciteParserSupplier, SqlExprToRexConverterFactory sqlExprToRexConverterFactory) {
        this.catalogManager = catalogManager;
        this.validatorSupplier = validatorSupplier;
        this.calciteParserSupplier = calciteParserSupplier;
        this.sqlExprToRexConverterFactory = sqlExprToRexConverterFactory;
    }

    public List<Operation> parse(String statement) {
        CalciteParser parser = this.calciteParserSupplier.get();
        FlinkPlannerImpl planner = this.validatorSupplier.get();
        Optional<Operation> command = EXTENDED_PARSER.parse(statement);
        if (command.isPresent()) {
            return Collections.singletonList(command.get());
        }
        SqlNodeList sqlNodeList = parser.parseSqlList(statement);
        List<SqlNode> parsed = sqlNodeList.getList();
        Preconditions.checkArgument((parsed.size() == 1 ? 1 : 0) != 0, (Object)"only single statement supported");
        return Collections.singletonList(SqlToOperationConverter.convert(planner, this.catalogManager, parsed.get(0)).orElseThrow(() -> new TableException("Unsupported query: " + statement)));
    }

    public UnresolvedIdentifier parseIdentifier(String identifier) {
        CalciteParser parser = this.calciteParserSupplier.get();
        SqlIdentifier sqlIdentifier = parser.parseIdentifier(identifier);
        return UnresolvedIdentifier.of(sqlIdentifier.names);
    }

    public ResolvedExpression parseSqlExpression(String sqlExpression, RowType inputRowType, @Nullable LogicalType outputType) {
        SqlExprToRexConverter sqlExprToRexConverter = this.sqlExprToRexConverterFactory.create(inputRowType, outputType);
        RexNode rexNode = sqlExprToRexConverter.convertToRexNode(sqlExpression);
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(rexNode.getType());
        String sqlExpressionExpanded = sqlExprToRexConverter.expand(sqlExpression);
        return new RexNodeExpression(rexNode, TypeConversions.fromLogicalToDataType((LogicalType)logicalType), sqlExpression, sqlExpressionExpanded);
    }

    public String[] getCompletionHints(String statement, int cursor) {
        ArrayList<String> candidates = new ArrayList<String>(Arrays.asList(EXTENDED_PARSER.getCompletionHints(statement, cursor)));
        SqlAdvisorValidator validator = this.validatorSupplier.get().getSqlAdvisorValidator();
        SqlAdvisor advisor = new SqlAdvisor(validator, this.validatorSupplier.get().config().getParserConfig());
        String[] replaced = new String[1];
        List sqlHints = advisor.getCompletionHints(statement, cursor, replaced).stream().map(item -> item.toIdentifier().toString()).collect(Collectors.toList());
        candidates.addAll(sqlHints);
        return candidates.toArray(new String[0]);
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }
}

