/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.IntListValuable;

public enum InlongUserTypeEnum implements IntListValuable
{
    INLONG_ADMIN(0),
    INLONG_OPERATOR(1);

    @JsonValue
    private final Integer code;
    private static final List<Integer> TYPE_CODE_LIST;

    private InlongUserTypeEnum(Integer code) {
        this.code = code;
    }

    public static InlongUserTypeEnum parseCode(Integer value) {
        return Arrays.stream(InlongUserTypeEnum.class.getEnumConstants()).filter(x -> x.getCode().equals(value)).findAny().orElse(null);
    }

    public static Integer parseName(String value) {
        for (InlongUserTypeEnum type : InlongUserTypeEnum.values()) {
            if (!type.name().equals(value)) continue;
            return type.code;
        }
        return null;
    }

    public static String name(Integer value) {
        return InlongUserTypeEnum.parseCode(value).name();
    }

    @Override
    public List<Integer> valueList() {
        return TYPE_CODE_LIST;
    }

    public Integer getCode() {
        return this.code;
    }

    static {
        TYPE_CODE_LIST = Arrays.stream(InlongUserTypeEnum.values()).map(InlongUserTypeEnum::getCode).collect(Collectors.toList());
    }
}

