/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.ScalaProductFieldAccessorFactory;
import org.apache.flink.util.Preconditions;
import scala.Product;

public class DefaultScalaProductFieldAccessorFactory
implements ScalaProductFieldAccessorFactory {
    public <T, F> FieldAccessor<T, F> createSimpleProductFieldAccessor(int pos, TypeInformation<T> typeInfo, ExecutionConfig config) {
        return new SimpleProductFieldAccessor(pos, typeInfo, config);
    }

    public <T, R, F> FieldAccessor<T, F> createRecursiveProductFieldAccessor(int pos, TypeInformation<T> typeInfo, FieldAccessor<R, F> innerAccessor, ExecutionConfig config) {
        return new RecursiveProductFieldAccessor<T, R, F>(pos, typeInfo, innerAccessor, config);
    }

    private static final class RecursiveProductFieldAccessor<T, R, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final TupleSerializerBase<T> serializer;
        private final Object[] fields;
        private final int length;
        private final FieldAccessor<R, F> innerAccessor;

        RecursiveProductFieldAccessor(int pos, TypeInformation<T> typeInfo, FieldAccessor<R, F> innerAccessor, ExecutionConfig config) {
            int arity = ((TupleTypeInfoBase)typeInfo).getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(pos).toString() + ". field on \"" + typeInfo.toString() + "\", which is an invalid index.");
            }
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            Preconditions.checkNotNull(innerAccessor, (String)"innerAccessor must not be null.");
            this.pos = pos;
            this.serializer = (TupleSerializerBase)typeInfo.createSerializer(config);
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
            this.innerAccessor = innerAccessor;
            this.fieldType = innerAccessor.getFieldType();
        }

        public F get(T record) {
            return (F)this.innerAccessor.get(((Product)record).productElement(this.pos));
        }

        public T set(T record, F fieldValue) {
            Product prod = (Product)record;
            for (int i = 0; i < this.length; ++i) {
                this.fields[i] = prod.productElement(i);
            }
            this.fields[this.pos] = this.innerAccessor.set(this.fields[this.pos], fieldValue);
            return (T)this.serializer.createInstance(this.fields);
        }
    }

    private static final class SimpleProductFieldAccessor<T, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final TupleSerializerBase<T> serializer;
        private final Object[] fields;
        private final int length;

        SimpleProductFieldAccessor(int pos, TypeInformation<T> typeInfo, ExecutionConfig config) {
            Preconditions.checkNotNull(typeInfo, (String)"typeInfo must not be null.");
            int arity = ((TupleTypeInfoBase)typeInfo).getArity();
            if (pos < 0 || pos >= arity) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(pos).toString() + ". field on \"" + typeInfo.toString() + "\", which is an invalid index.");
            }
            this.pos = pos;
            this.fieldType = ((TupleTypeInfoBase)typeInfo).getTypeAt(pos);
            this.serializer = (TupleSerializerBase)typeInfo.createSerializer(config);
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
        }

        public F get(T record) {
            Product prod = (Product)record;
            return (F)prod.productElement(this.pos);
        }

        public T set(T record, F fieldValue) {
            Product prod = (Product)record;
            for (int i = 0; i < this.length; ++i) {
                this.fields[i] = prod.productElement(i);
            }
            this.fields[this.pos] = fieldValue;
            return (T)this.serializer.createInstance(this.fields);
        }
    }
}

