/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.metrics.MinWatermarkGauge;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public abstract class AbstractTwoInputStreamTask<IN1, IN2, OUT>
extends StreamTask<OUT, TwoInputStreamOperator<IN1, IN2, OUT>> {
    protected final WatermarkGauge input1WatermarkGauge = new WatermarkGauge();
    protected final WatermarkGauge input2WatermarkGauge = new WatermarkGauge();
    protected final MinWatermarkGauge minInputWatermarkGauge = new MinWatermarkGauge(this.input1WatermarkGauge, this.input2WatermarkGauge);

    public AbstractTwoInputStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        ClassLoader userClassLoader = this.getUserCodeClassLoader();
        int numberOfInputs = configuration.getNumberOfNetworkInputs();
        ArrayList<IndexedInputGate> inputList1 = new ArrayList<IndexedInputGate>();
        ArrayList<IndexedInputGate> inputList2 = new ArrayList<IndexedInputGate>();
        List<StreamEdge> inEdges = configuration.getInPhysicalEdges(userClassLoader);
        block4: for (int i = 0; i < numberOfInputs; ++i) {
            int inputType = inEdges.get(i).getTypeNumber();
            IndexedInputGate reader = this.getEnvironment().getInputGate(i);
            switch (inputType) {
                case 1: {
                    inputList1.add(reader);
                    continue block4;
                }
                case 2: {
                    inputList2.add(reader);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Invalid input type number: " + inputType);
                }
            }
        }
        this.createInputProcessor(inputList1, inputList2, gateIndex -> ((StreamEdge)inEdges.get((int)gateIndex)).getPartitioner());
        ((TwoInputStreamOperator)this.mainOperator).getMetricGroup().gauge("currentInputWatermark", (Gauge)this.minInputWatermarkGauge);
        ((TwoInputStreamOperator)this.mainOperator).getMetricGroup().gauge("currentInput1Watermark", (Gauge)this.input1WatermarkGauge);
        ((TwoInputStreamOperator)this.mainOperator).getMetricGroup().gauge("currentInput2Watermark", (Gauge)this.input2WatermarkGauge);
        this.getEnvironment().getMetricGroup().gauge("currentInputWatermark", this.minInputWatermarkGauge::getValue);
    }

    protected abstract void createInputProcessor(List<IndexedInputGate> var1, List<IndexedInputGate> var2, Function<Integer, StreamPartitioner<?>> var3) throws Exception;
}

