/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.SettingValidUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbTopicAuthControlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;

public class TopicCtrlEntity
extends BaseEntity
implements Cloneable {
    private String topicName = "";
    private int topicNameId = -2;
    private EnableStatus authCtrlStatus = EnableStatus.STATUS_UNDEFINE;
    private int maxMsgSizeInB = -2;
    private int maxMsgSizeInMB = -2;

    public TopicCtrlEntity() {
    }

    public TopicCtrlEntity(BaseEntity opEntity, String topicName) {
        super(opEntity);
        this.topicName = topicName;
    }

    public TopicCtrlEntity(BaseEntity opEntity, String topicName, int topicNameId, int maxMsgSizeInMB) {
        super(opEntity.getDataVerId(), opEntity.getModifyUser(), opEntity.getModifyDate());
        this.topicName = topicName;
        this.topicNameId = topicNameId;
        this.authCtrlStatus = EnableStatus.STATUS_DISABLE;
        this.fillMaxMsgSizeInMB(maxMsgSizeInMB);
    }

    public TopicCtrlEntity(BdbTopicAuthControlEntity bdbEntity) {
        super(bdbEntity.getDataVerId(), bdbEntity.getModifyUser(), bdbEntity.getModifyDate());
        this.setCreateInfo(bdbEntity.getCreateUser(), bdbEntity.getCreateDate());
        this.topicName = bdbEntity.getTopicName();
        this.topicNameId = bdbEntity.getTopicId();
        this.fillMaxMsgSizeInB(bdbEntity.getMaxMsgSize());
        this.authCtrlStatus = bdbEntity.isEnableAuthControl() ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbTopicAuthControlEntity buildBdbTopicAuthControlEntity() {
        BdbTopicAuthControlEntity bdbEntity = new BdbTopicAuthControlEntity(this.topicName, this.isAuthCtrlEnable(), this.getAttributes(), this.getModifyUser(), this.getModifyDate());
        bdbEntity.setCreateInfo(this.getCreateUser(), this.getCreateDate());
        bdbEntity.setTopicId(this.topicNameId);
        bdbEntity.setDataVerId(this.getDataVerId());
        bdbEntity.setMaxMsgSize(this.maxMsgSizeInB);
        return bdbEntity;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public boolean isAuthCtrlEnable() {
        return this.authCtrlStatus == EnableStatus.STATUS_ENABLE;
    }

    public EnableStatus getAuthCtrlStatus() {
        return this.authCtrlStatus;
    }

    public void setAuthCtrlStatus(EnableStatus authCtrlStatus) {
        if (authCtrlStatus != null) {
            this.authCtrlStatus = authCtrlStatus;
        }
    }

    public int getMaxMsgSizeInB() {
        return this.maxMsgSizeInB;
    }

    public int getMaxMsgSizeInMB() {
        return this.maxMsgSizeInMB;
    }

    public int getTopicId() {
        return this.topicNameId;
    }

    public void setTopicId(int topicNameId) {
        this.topicNameId = topicNameId;
    }

    public boolean updModifyInfo(long dataVerId, int topicNameId, int newMaxMsgSizeMB, EnableStatus enableTopicAuth) {
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (topicNameId != -2 && this.topicNameId != topicNameId) {
            changed = true;
            this.topicNameId = topicNameId;
        }
        if (newMaxMsgSizeMB != -2) {
            changed = this.fillMaxMsgSizeInMB(newMaxMsgSizeMB);
        }
        if (enableTopicAuth != null && enableTopicAuth != EnableStatus.STATUS_UNDEFINE && this.authCtrlStatus != enableTopicAuth) {
            this.setAuthCtrlStatus(enableTopicAuth);
            changed = true;
        }
        if (changed) {
            this.updSerialId();
        }
        return changed;
    }

    public TopicCtrlEntity fillEmptyValues(ClusterSettingEntity defSetting) {
        if (this.maxMsgSizeInMB == -2) {
            int tmpMaxMsgSizeInMB = 1;
            if (defSetting != null) {
                tmpMaxMsgSizeInMB = defSetting.getMaxMsgSizeInMB();
            }
            this.fillMaxMsgSizeInMB(tmpMaxMsgSizeInMB);
        }
        if (this.authCtrlStatus == EnableStatus.STATUS_UNDEFINE) {
            this.authCtrlStatus = EnableStatus.STATUS_DISABLE;
        }
        return this;
    }

    public boolean isMatched(TopicCtrlEntity target, boolean fullMatch) {
        if (target == null) {
            return true;
        }
        if (fullMatch && !super.isMatched(target)) {
            return false;
        }
        return !(target.getMaxMsgSizeInB() != -2 && target.getMaxMsgSizeInB() != this.maxMsgSizeInB || !TStringUtils.isBlank((String)target.getTopicName()) && !target.getTopicName().equals(this.topicName) || target.getAuthCtrlStatus() != EnableStatus.STATUS_UNDEFINE && target.getAuthCtrlStatus() != this.authCtrlStatus || target.getTopicId() != -2 && target.getTopicId() != this.topicNameId);
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName, boolean fullFormat) {
        if (isLongName) {
            sBuilder.append("{\"topicName\":\"").append(this.topicName).append("\"").append(",\"topicNameId\":").append(this.topicNameId).append(",\"enableAuthControl\":").append(this.authCtrlStatus.isEnable()).append(",\"maxMsgSizeInMB\":").append(this.maxMsgSizeInMB);
        } else {
            sBuilder.append("{\"topic\":\"").append(this.topicName).append("\"").append(",\"topicId\":").append(this.topicNameId).append(",\"acEn\":").append(this.authCtrlStatus.isEnable()).append(",\"mxMsgInMB\":").append(this.maxMsgSizeInMB);
        }
        super.toWebJsonStr(sBuilder, isLongName);
        if (fullFormat) {
            sBuilder.append("}");
        }
        return sBuilder;
    }

    private boolean fillMaxMsgSizeInB(int maxMsgSizeInB) {
        boolean changed = false;
        int tmpMaxMsgSizeInMB = SettingValidUtils.validAndGetMsgSizeBtoMB((int)maxMsgSizeInB);
        if (this.maxMsgSizeInMB != tmpMaxMsgSizeInMB) {
            changed = true;
            this.maxMsgSizeInMB = tmpMaxMsgSizeInMB;
            this.maxMsgSizeInB = SettingValidUtils.validAndXfeMaxMsgSizeFromMBtoB((int)tmpMaxMsgSizeInMB);
        }
        return changed;
    }

    private boolean fillMaxMsgSizeInMB(int maxMsgSizeInMB) {
        boolean changed = false;
        int tmpMaxMsgSizeInMB = SettingValidUtils.validAndGetMsgSizeInMB((int)maxMsgSizeInMB);
        if (this.maxMsgSizeInMB != tmpMaxMsgSizeInMB) {
            changed = true;
            this.maxMsgSizeInMB = tmpMaxMsgSizeInMB;
            this.maxMsgSizeInB = SettingValidUtils.validAndXfeMaxMsgSizeFromMBtoB((int)tmpMaxMsgSizeInMB);
        }
        return changed;
    }

    public boolean isDataEquals(TopicCtrlEntity other) {
        return super.isDataEquals(other) && this.topicNameId == other.topicNameId && this.maxMsgSizeInB == other.maxMsgSizeInB && this.topicName.equals(other.topicName) && this.authCtrlStatus == other.authCtrlStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicCtrlEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicCtrlEntity that = (TopicCtrlEntity)o;
        return this.isDataEquals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.topicName, this.topicNameId, this.authCtrlStatus, this.maxMsgSizeInB});
    }

    @Override
    public TopicCtrlEntity clone() {
        TopicCtrlEntity copy = (TopicCtrlEntity)super.clone();
        copy.setAuthCtrlStatus(this.getAuthCtrlStatus());
        return copy;
    }
}

