/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.statusdef;

public enum EnableStatus {
    STATUS_UNDEFINE(-2, "Undefined."),
    STATUS_DISABLE(0, "Disable."),
    STATUS_ENABLE(2, "Enable.");

    private int code;
    private String description;

    private EnableStatus(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isEnable() {
        return this == STATUS_ENABLE;
    }

    public String getDescription() {
        return this.description;
    }

    public static EnableStatus valueOf(int code) {
        for (EnableStatus status : EnableStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown Enable status code %s", code));
    }
}

