/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.nodeinfo;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlResult;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlRuleHandler;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;

public class ConsumerNodeInfo {
    private final String partStr;
    private final MessageStoreManager storeManager;
    private String consumerId;
    private final String groupName;
    private final String sessionKey;
    private final long sessionTime;
    private boolean isFilterConsume = false;
    private final Set<String> filterCondStrs = new HashSet<String>(10);
    private final Set<Integer> filterCondCode = new HashSet<Integer>(10);
    private String addrRcvFrom;
    private String rmtAddrInfo;
    private boolean isSupportLimit = false;
    private long nextStatTime = 0L;
    private long lastGetTime = 0L;
    private long lastDataRdOffset = -2L;
    private int sentMsgSize = 0;
    private int sentUnit = 327680;
    private long totalUnitSec = 0L;
    private long totalUnitMin = 0L;
    private FlowCtrlResult curFlowCtrlVal = new FlowCtrlResult(Long.MAX_VALUE, 0);
    private long nextLimitUpdateTime = 0L;
    private final AtomicInteger qryPriorityId = new AtomicInteger(-2);
    private long createTime = System.currentTimeMillis();

    public ConsumerNodeInfo(MessageStoreManager storeManager, String groupName, String consumerId, Set<String> filterCodes, String sessionKey, long sessionTime, String partStr, String msgRcvFrom) {
        this(storeManager, -2, groupName, consumerId, filterCodes, sessionKey, sessionTime, false, partStr, msgRcvFrom);
    }

    public ConsumerNodeInfo(MessageStoreManager storeManager, int qryPriorityId, String groupName, String consumerId, Set<String> filterCodes, String sessionKey, long sessionTime, boolean isSupportLimit, String partStr, String msgRcvFrom) {
        this.setConsumerId(consumerId);
        if (filterCodes != null) {
            for (String filterItem : filterCodes) {
                this.filterCondStrs.add(filterItem);
                this.filterCondCode.add(filterItem.hashCode());
            }
        }
        this.groupName = groupName;
        this.sessionKey = sessionKey;
        this.sessionTime = sessionTime;
        this.qryPriorityId.set(qryPriorityId);
        this.storeManager = storeManager;
        this.partStr = partStr;
        this.addrRcvFrom = msgRcvFrom;
        this.createTime = System.currentTimeMillis();
        if (filterCodes != null && !filterCodes.isEmpty()) {
            this.isFilterConsume = true;
        }
        this.isSupportLimit = isSupportLimit;
    }

    public int getCurrentAllowedSize(String storeKey, FlowCtrlRuleHandler flowCtrlRuleHandler, long currMaxDataOffset, int maxMsgTransferSize, boolean isEscFlowCtrl) {
        if (this.lastDataRdOffset >= 0L) {
            long curDataDlt = currMaxDataOffset - this.lastDataRdOffset;
            long currTime = System.currentTimeMillis();
            this.recalcMsgLimitValue(curDataDlt, currTime, maxMsgTransferSize, flowCtrlRuleHandler);
            if (isEscFlowCtrl || this.totalUnitSec > (long)this.sentMsgSize && this.curFlowCtrlVal.dataLtInSize > this.totalUnitMin) {
                return this.sentUnit;
            }
            if (this.isSupportLimit) {
                return -this.curFlowCtrlVal.freqLtInMs;
            }
            return 0;
        }
        return this.sentUnit;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getPartStr() {
        return this.partStr;
    }

    public int getSentMsgSize() {
        return this.sentMsgSize;
    }

    public boolean isSupportLimit() {
        return this.isSupportLimit;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId.get();
    }

    public void setQryPriorityId(int qryPriorityId) {
        this.qryPriorityId.set(qryPriorityId);
    }

    public long getNextStatTime() {
        return this.nextStatTime;
    }

    public long getLastDataRdOffset() {
        return this.lastDataRdOffset;
    }

    public int getSentUnit() {
        return this.sentUnit;
    }

    public long getTotalUnitSec() {
        return this.totalUnitSec;
    }

    public long getTotalUnitMin() {
        return this.totalUnitMin;
    }

    public FlowCtrlResult getCurFlowCtrlVal() {
        return this.curFlowCtrlVal;
    }

    public long getNextLimitUpdateTime() {
        return this.nextLimitUpdateTime;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        String targetStr;
        String[] strInfos;
        this.consumerId = consumerId;
        if (consumerId.lastIndexOf("_") != -1 && (strInfos = (targetStr = consumerId.substring(consumerId.lastIndexOf("_") + 1)).split("-")).length > 2) {
            this.rmtAddrInfo = new StringBuilder(256).append(strInfos[0]).append("#").append(strInfos[1]).toString();
        }
    }

    public Set<Integer> getFilterCondCodeSet() {
        return this.filterCondCode;
    }

    public Set<String> getFilterCondStrs() {
        return this.filterCondStrs;
    }

    public long getCurFlowCtrlLimitSize() {
        return this.curFlowCtrlVal.dataLtInSize / 1024L / 1024L;
    }

    public int getCurFlowCtrlFreqLimit() {
        return this.curFlowCtrlVal.freqLtInMs;
    }

    public boolean isFilterConsume() {
        return this.isFilterConsume;
    }

    public long getLastGetTime() {
        return this.lastGetTime;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public String getAddrRcvFrom() {
        return this.addrRcvFrom;
    }

    public void setLastProcInfo(long lastGetTime, long lastRdDataOffset, int totalMsgSize) {
        this.lastGetTime = lastGetTime;
        this.lastDataRdOffset = lastRdDataOffset;
        this.sentMsgSize += totalMsgSize;
        this.totalUnitMin += (long)totalMsgSize;
    }

    public String getRmtAddrInfo() {
        return this.rmtAddrInfo;
    }

    private void recalcMsgLimitValue(long curDataDlt, long currTime, int maxMsgTransferSize, FlowCtrlRuleHandler flowCtrlRuleHandler) {
        if (currTime > this.nextLimitUpdateTime) {
            this.curFlowCtrlVal = flowCtrlRuleHandler.getCurDataLimit(curDataDlt);
            if (this.curFlowCtrlVal == null) {
                this.curFlowCtrlVal = new FlowCtrlResult(Long.MAX_VALUE, 0);
            }
            currTime = System.currentTimeMillis();
            this.sentMsgSize = 0;
            this.totalUnitMin = 0L;
            this.nextStatTime = currTime + 5000L;
            this.nextLimitUpdateTime = currTime + 60000L;
            this.totalUnitSec = this.curFlowCtrlVal.dataLtInSize / 12L;
            this.sentUnit = this.totalUnitSec > (long)maxMsgTransferSize ? maxMsgTransferSize : (int)this.totalUnitSec;
        } else if (currTime > this.nextStatTime) {
            this.sentMsgSize = 0;
            this.nextStatTime = currTime + 5000L;
        }
    }
}

