/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMb!B\u001e=\u0001q\u0002\u0005\u0002C*\u0001\u0005\u000b\u0007I\u0011A+\t\u0011\u0011\u0004!\u0011!Q\u0001\nYC\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\ts\u0002\u0011\t\u0011)A\u0005O\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005y\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\n\u0001\u0011E\u0013Q\u0003\u0005\u000b\u0003G\u0001!\u0019!C\u0001y\u0005U\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0006\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0002\"CA!\u0001\u0001\u0007I\u0011BA\"\u0011!\ty\u0005\u0001Q!\n\u0005-\u0002\"CA-\u0001\t\u0007I\u0011BA.\u0011!\ty\u0007\u0001Q\u0001\n\u0005u\u0003\"CA9\u0001\t\u0007I\u0011BA:\u0011!\t\t\n\u0001Q\u0001\n\u0005U\u0004\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\tY\u000b\u0001Q\u0001\n\u0005]\u0005\"CAW\u0001\t\u0007I\u0011BAX\u0011!\t9\f\u0001Q\u0001\n\u0005E\u0006\"CA]\u0001\u0001\u0007I\u0011BA^\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0015BA_\u0011%\ti\r\u0001a\u0001\n\u0013\ty\rC\u0005\u0002X\u0002\u0001\r\u0011\"\u0003\u0002Z\"A\u0011Q\u001c\u0001!B\u0013\t\t\u000eC\u0004\u0002b\u0002!\t!a9\t\u0011\u0005%\b\u0001\"\u0001=\u0003WD\u0001\"a>\u0001\t\u0003a\u0014\u0011 \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011%\u0011)\u0003AI\u0001\n\u0003\u00119\u0003C\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t5\u0003\u0001\"\u0001\u0003@!9!q\n\u0001\u0005\u0002\tE\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005;\u0002A\u0011\u0001B0\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqAa\u001e\u0001\t\u0013\u0011I\bC\u0004\u0003~\u0001!\tAa \t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\"I!\u0011\u0014\u0001\u0012\u0002\u0013\u0005!1\u0014\u0005\n\u0005?\u0003\u0011\u0013!C\u0001\u0005CCqA!*\u0001\t\u0003\u00119\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\t\u0003c\u0002A\u0011\u0001\u001f\u0003Z\"9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bw\u0001\u0011%!q^\u0004\t\u0005kd\u0004\u0012\u0001\u001f\u0003x\u001a91\b\u0010E\u0001y\te\bbBA\u0004k\u0011\u0005!1 \u0005\b\u0005{,D\u0011\u0001B\u0000\u0011\u001d\u0019\u0019!\u000eC\u0001\u0007\u000bAqa!\u00056\t\u0003\u0019\u0019\u0002C\u0004\u0004&U\"\taa\n\u0003#1{wm\u00117fC:,'/T1oC\u001e,'O\u0003\u0002>}\u0005\u0019An\\4\u000b\u0003}\nQa[1gW\u0006\u001cB\u0001A!H\u001bB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\u0004\"\u0001S&\u000e\u0003%S!A\u0013 \u0002\u000bU$\u0018\u000e\\:\n\u00051K%a\u0002'pO\u001eLgn\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!z\nq!\\3ue&\u001c7/\u0003\u0002S\u001f\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u000f1|w\rR5sg\u000e\u0001Q#\u0001,\u0011\u0007]SF,D\u0001Y\u0015\tI6)\u0001\u0006d_2dWm\u0019;j_:L!a\u0017-\u0003\u0007M+\u0017\u000f\u0005\u0002^E6\taL\u0003\u0002`A\u0006\u0011\u0011n\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gL\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002OB!\u0001\n\u001b6v\u0013\tI\u0017J\u0001\u0003Q_>d\u0007CA6t\u001b\u0005a'BA7o\u0003\u0019\u0019w.\\7p]*\u0011qh\u001c\u0006\u0003aF\fa!\u00199bG\",'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uY\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001<x\u001b\u0005a\u0014B\u0001==\u0005\raunZ\u0001\u0006Y><7\u000fI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@?\u0003\u0019\u0019XM\u001d<fe&\u0019\u00111\u0001@\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\na\u0001P5oSRtD\u0003CA\u0006\u0003\u001b\ty!!\u0005\u0011\u0005Y\u0004\u0001\"B*\b\u0001\u00041\u0006\"B3\b\u0001\u00049\u0007\"\u0002>\b\u0001\u0004a\u0018A\u00037pO\u001e,'OT1nKV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u00041\u0002\t1\fgnZ\u0005\u0005\u0003C\tYB\u0001\u0004TiJLgnZ\u0001\u0015_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002+=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7fA\u0005Y1\r[3dWB|\u0017N\u001c;t+\t\tY\u0003E\u0004\u0002.\u0005MB,a\u000e\u000e\u0005\u0005=\"bAA\u00191\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003k\tyCA\u0002NCB\u0004B!!\u000f\u0002>5\u0011\u00111\b\u0006\u0004\u0003Oq\u0018\u0002BA \u0003w\u0011Ac\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017aD2iK\u000e\\\u0007o\\5oiN|F%Z9\u0015\t\u0005\u0015\u00131\n\t\u0004\u0005\u0006\u001d\u0013bAA%\u0007\n!QK\\5u\u0011%\ti\u0005DA\u0001\u0002\u0004\tY#A\u0002yIE\nAb\u00195fG.\u0004x.\u001b8ug\u0002B3!DA*!\r\u0011\u0015QK\u0005\u0004\u0003/\u001a%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015%t\u0007K]8he\u0016\u001c8/\u0006\u0002\u0002^A9\u0011qLA3U\u0006%TBAA1\u0015\r\t\u0019\u0007W\u0001\b[V$\u0018M\u00197f\u0013\u0011\t9'!\u0019\u0003\u000f!\u000b7\u000f['baB\u0019a/a\u001b\n\u0007\u00055DH\u0001\tM_\u001e\u001cE.Z1oS:<7\u000b^1uK\u0006Y\u0011N\u001c)s_\u001e\u0014Xm]:!\u0003U)hn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]N,\"!!\u001e\u0011\u0011\u0005}\u0013QMA<\u0003\u0017\u0003B!!\u001f\u0002\b:!\u00111PAB!\r\tihQ\u0007\u0003\u0003\u007fR1!!!U\u0003\u0019a$o\\8u}%\u0019\u0011QQ\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#!#\u000b\u0007\u0005\u00155\tE\u0003\u0002`\u00055%.\u0003\u0003\u0002\u0010\u0006\u0005$aA*fi\u00061RO\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0003m_\u000e\\WCAAL!\u0011\tI*a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bQ\u0001\\8dWNTA!!)\u0002$\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u0015\u0006-\u0001\u0003vi&d\u0017\u0002BAU\u00037\u0013QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013A\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012,\"!!-\u0011\t\u0005e\u00151W\u0005\u0005\u0003k\u000bYJA\u0005D_:$\u0017\u000e^5p]\u0006\u0019\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8eA\u0005IB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p+\t\ti\fE\u0002C\u0003\u007fK1!!1D\u0005\u0019!u.\u001e2mK\u0006iB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005\u001d\u0007\"CA'/\u0005\u0005\t\u0019AA_\u0003i!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8!Q\rA\u00121K\u0001\u000ei&lWm\u00144MCN$(+\u001e8\u0016\u0005\u0005E\u0007c\u0001\"\u0002T&\u0019\u0011Q[\"\u0003\t1{gnZ\u0001\u0012i&lWm\u00144MCN$(+\u001e8`I\u0015\fH\u0003BA#\u00037D\u0011\"!\u0014\u001b\u0003\u0003\u0005\r!!5\u0002\u001dQLW.Z(g\u0019\u0006\u001cHOU;oA!\u001a1$a\u0015\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u0011Q\u001d\t\b\u0003s\n9O[Ai\u0013\u0011\t)$!#\u0002\u001b\rdW-\u00198j]\u001e\u001cF/\u0019;f)\u0011\ti/a=\u0011\u000b\t\u000by/!\u001b\n\u0007\u0005E8I\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003kl\u0002\u0019\u00016\u0002\u0005Q\u0004\u0018\u0001E:fi\u000ecW-\u00198j]\u001e\u001cF/\u0019;f)\u0019\t)%a?\u0002~\"1\u0011Q\u001f\u0010A\u0002)Dq!a@\u001f\u0001\u0004\tI'A\u0003ti\u0006$X-A\rhe\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><GC\u0002B\u0003\u0005\u001b\u0011Y\u0002E\u0003C\u0003_\u00149\u0001E\u0002w\u0005\u0013I1Aa\u0003=\u0005)aun\u001a+p\u00072,\u0017M\u001c\u0005\b\u0005\u001fy\u0002\u0019\u0001B\t\u0003\u0011!\u0018.\\3\u0011\t\tM!qC\u0007\u0003\u0005+Q!A\u00137\n\t\te!Q\u0003\u0002\u0005)&lW\rC\u0005\u0003\u001e}\u0001\n\u00111\u0001\u0003 \u0005i\u0001O]3DY\u0016\fgn\u0015;biN\u00042A\u001eB\u0011\u0013\r\u0011\u0019\u0003\u0010\u0002\u000e!J,7\t\\3b]N#\u0018\r^:\u0002G\u001d\u0014\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0006\u0016\u0005\u0005?\u0011Yc\u000b\u0002\u0003.A!!q\u0006B\u001d\u001b\t\u0011\tD\u0003\u0003\u00034\tU\u0012!C;oG\",7m[3e\u0015\r\u00119dQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001e\u0005c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0019\u0002\u0018-^:f\u00072,\u0017M\\5oO\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005\u0003\u0002Ra\u0016B\"\u0005\u000fJ1A!\u0012Y\u0005!IE/\u001a:bE2,\u0007#\u0002\"\u0003J),\u0018b\u0001B&\u0007\n1A+\u001e9mKJ\nQ\u0002Z3mKR\f'\r\\3M_\u001e\u001c\u0018!D1c_J$8\t\\3b]&tw\r\u0006\u0003\u0002F\tM\u0003B\u0002B+G\u0001\u0007!.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+\u0005\u0014wN\u001d;B]\u0012\u0004\u0016-^:f\u00072,\u0017M\\5oOR!\u0011Q\tB.\u0011\u0019\u0011)\u0006\na\u0001U\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA#\u0005CBqAa\u0019&\u0001\u0004\u0011)'A\bu_BL7\rU1si&$\u0018n\u001c8t!\u00119&1\t6\u0002#%\u001c8\t\\3b]&tw-\u00138Ti\u0006$X\r\u0006\u0004\u0003l\tE$1\u000f\t\u0004\u0005\n5\u0014b\u0001B8\u0007\n9!i\\8mK\u0006t\u0007B\u0002B+M\u0001\u0007!\u000eC\u0004\u0003v\u0019\u0002\r!!\u001b\u0002\u001b\u0015D\b/Z2uK\u0012\u001cF/\u0019;f\u0003]I7o\u00117fC:LgnZ%o'R\fG/\u001a)bkN,G\r\u0006\u0003\u0003l\tm\u0004B\u0002B+O\u0001\u0007!.\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0005\u0003\u000b\u0012\t\t\u0003\u0004\u0003V!\u0002\rA[\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003CA#\u0005\u000f\u0013YIa%\t\r\t%\u0015\u00061\u0001]\u0003\u001d!\u0017\r^1ESJD\u0011B!$*!\u0003\u0005\rAa$\u0002-A\f'\u000f^5uS>tGk\\+qI\u0006$Xm\u0014:BI\u0012\u0004RAQAx\u0005#\u0003bA\u0011B%U\u0006E\u0007\"\u0003BKSA\u0005\t\u0019\u0001BL\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8SK6|g/\u001a\t\u0005\u0005\u0006=(.A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HEM\u000b\u0003\u0005;SCAa$\u0003,\u0005YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uIM*\"Aa)+\t\t]%1F\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002F\t%&1\u0016BX\u0011\u0019\u0011)\u0006\fa\u0001U\"1!Q\u0016\u0017A\u0002q\u000bAb]8ve\u000e,Gj\\4ESJDaA!--\u0001\u0004a\u0016A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u0011Q\tB\\\u0011\u001d\u0011I,\fa\u0001\u0003o\n1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002F\t}&\u0011\u0019Bb\u0011\u0019\u0011II\fa\u00019\"1!Q\u000b\u0018A\u0002)DqA!2/\u0001\u0004\t\t.\u0001\u0004pM\u001a\u001cX\r^\u0001\rI>tWm\u00117fC:Lgn\u001a\u000b\t\u0003\u000b\u0012YM!4\u0003P\"1!QK\u0018A\u0002)DaA!#0\u0001\u0004a\u0006b\u0002Bi_\u0001\u0007\u0011\u0011[\u0001\nK:$wJ\u001a4tKR\fA\u0002Z8oK\u0012+G.\u001a;j]\u001e$B!!\u0012\u0003X\"9!1\r\u0019A\u0002\t\u0015D\u0003\u0002Bn\u0005?\u0004R!!\u001f\u0003^*LA!a$\u0002\n\"9!\u0011]\u0019A\u0002\u0005]\u0014A\u00027pO\u0012K'/\u0001\rnCJ\\\u0007+\u0019:uSRLwN\\+oG2,\u0017M\\1cY\u0016$b!!\u0012\u0003h\n%\bb\u0002Bqe\u0001\u0007\u0011q\u000f\u0005\u0007\u0005W\u0014\u0004\u0019\u00016\u0002\u0013A\f'\u000f^5uS>t\u0017AF5t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8\u0015\r\t-$\u0011\u001fBz\u0011\u0015i4\u00071\u0001v\u0011\u0019\u0011)f\ra\u0001U\u0006\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0005Y,4cA\u001bB\u000fR\u0011!q_\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0003l\r\u0005\u0001\"B\u001f8\u0001\u0004)\u0018AE7bq\u000e{W\u000e]1di&|g\u000eR3mCf$\u0002\"!5\u0004\b\r%1Q\u0002\u0005\u0006{a\u0002\r!\u001e\u0005\b\u0007\u0017A\u0004\u0019AAi\u0003A1\u0017N]:u\t&\u0014H/_(gMN,G\u000fC\u0004\u0004\u0010a\u0002\r!!5\u0002\u00079|w/\u0001\tdY\u0016\fg.\u00192mK>3gm]3ugRA1QCB\u000e\u0007;\u0019\u0019\u0003E\u0002w\u0007/I1a!\u0007=\u00059yeMZ:fiN$vn\u00117fC:DQ!P\u001dA\u0002UDqaa\b:\u0001\u0004\u0019\t#A\bmCN$8\t\\3b]>3gm]3u!\u0015\u0011\u0015q^Ai\u0011\u001d\u0019y!\u000fa\u0001\u0003#\fqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\r%21FB\u0017\u0007_\u0001rA\u0011B%\u0003#\f\t\u000eC\u0003>u\u0001\u0007Q\u000fC\u0004\u0004\fi\u0002\r!!5\t\u000f\rE\"\b1\u0001\u0002R\u0006\tRO\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static OffsetsToClean cleanableOffsets(Log log, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, option, l);
    }

    public static long maxCompactionDelay(Log log, long l, long l2) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(log, l, l2);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    private double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    private void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void abortCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (!bl) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                int count = logCleaningPaused.pausedCount();
                if (count <= 1) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            bl = !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2 = (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkCleaningAborted(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleLogDirFailure(String dir) {
        void inLock_lock;
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$3, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        void inLock_lock;
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((GenTraversableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    /*
     * WARNING - void declaration
     */
    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUncleanablePartition(Log log, TopicPartition topicPartition) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$new$5() {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        Option option = $this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((Set)map_this.get()).size()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? BoxesRunTime.boxToInteger((int)LogCleanerManager.$anonfun$new$5()) : object.get();
        return BoxesRunTime.unboxToInt((Object)object2);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        int n;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3(this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        Option lastCleanOffset;
        OffsetsToClean offsetsToClean;
        Log log = $this.logs().get(tp);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, (offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)(lastCleanOffset = lastClean$1.get((Object)tp)), now$1)).firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long l = tuple2._2$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        long l;
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            l = BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError((Object)option);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        long l;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$8(this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$10() {
        return (int)((double)100 * this.dirtiestLogCleanableRatio());
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$11() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((TraversableOnce)$this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$1) {
        return $this.inProgress().get((Object)tp$1);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$2, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$2, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Log)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        Log log = (Log)x0$2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogToClean logToClean;
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                Log log = (Log)x0$3._2();
                try {
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, offsetsToClean.firstDirtyOffset(), now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    logToClean = new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            } else {
                throw new MatchError(null);
            }
            LogToClean logToClean2 = logToClean;
            return logToClean2;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Log)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        void var1_1;
        Iterable deletableLogs = (Iterable)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            Option option = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        Log log = (Log)x0$1._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        void var1_1;
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Option option = $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.logs().keys().contains((Object)tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((TraversableOnce)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartion = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartion);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = map2.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = map2;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                checkpoint.write((Map<TopicPartition, Object>)map);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ Option $anonfun$alterCheckpointDir$2(TopicPartition topicPartition$4, OffsetCheckpointFile x$2) {
        return x$2.read().get((Object)topicPartition$4);
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            None$ none$;
            Option option = $this.checkpoints().get((Object)sourceLogDir$1);
            if (option == null) {
                throw null;
            }
            Option flatMap_this = option;
            if (flatMap_this.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                OffsetCheckpointFile offsetCheckpointFile = (OffsetCheckpointFile)flatMap_this.get();
                none$ = LogCleanerManager.$anonfun$alterCheckpointDir$2(topicPartition$4, offsetCheckpointFile);
            }
            if (none$ instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)none$).value());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("from ").append(sourceLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                Option x$2 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Object>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$2);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("to ").append(destLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(none$)) {
                throw new MatchError((Object)none$);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((File)x0$1._1()).getAbsolutePath();
        boolean bl = string == null ? dir$3 != null : !string.equals(dir$3);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        Map<TopicPartition, Object> existing;
        OffsetCheckpointFile checkpoint;
        if ($this.logs().get(topicPartition$5).config().compact() && (checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset$1) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Long l = BoxesRunTime.boxToLong((long)offset$1);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            checkpoint.write((Map<TopicPartition, Object>)((Map)((MapLike)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(existing)).$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y))));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
        throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Boolean bl;
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            bl = BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        } else if (None$.MODULE$.equals(option)) {
            bl = $this.uncleanablePartitions().put((Object)logDir$2, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, Log log$1, TopicPartition topicPartition$7) {
        Set set;
        Option option = $this.uncleanablePartitions().get((Object)log$1.parentDir());
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && (set = (Set)exists_this.get()).contains((Object)topicPartition$7);
        return bl;
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = dir.getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"logDirectory");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$1;

                public final int value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$1 = dir$1;
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = dir.getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"logDirectory");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$2;

                public final long value() {
                    return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$2 = dir$2;
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
        this.dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$10();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public static final /* synthetic */ Object $anonfun$new$4$adapted(Set x$1) {
        return BoxesRunTime.boxToInteger((int)x$1.size());
    }

    public static final /* synthetic */ Object $anonfun$isUncleanablePartition$2$adapted(TopicPartition topicPartition$7, Set partitions) {
        return BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7));
    }
}

