/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionLog$KeySchema$;
import kafka.coordinator.transaction.TransactionLog$ValueSchema$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class TransactionLog$ {
    public static TransactionLog$ MODULE$;
    private final int DefaultNumPartitions;
    private final int DefaultSegmentBytes;
    private final short DefaultReplicationFactor;
    private final int DefaultMinInSyncReplicas;
    private final int DefaultLoadBufferSize;
    private final CompressionType EnforcedCompressionType;
    private final short EnforcedRequiredAcks;

    static {
        new TransactionLog$();
    }

    public int DefaultNumPartitions() {
        return this.DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return this.DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return this.DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return this.DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return this.EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return this.EnforcedRequiredAcks;
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForKey(int version) {
        Option<Schema> option = TransactionLog$KeySchema$.MODULE$.ofVersion(version);
        if (option == null) {
            throw null;
        }
        Option<Schema> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionLog$.$anonfun$schemaForKey$1(version);
        }
        return (Schema)getOrElse_this.get();
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForValue(int version) {
        Option<Schema> option = TransactionLog$ValueSchema$.MODULE$.ofVersion(version);
        if (option == null) {
            throw null;
        }
        Option<Schema> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionLog$.$anonfun$schemaForValue$1(version);
        }
        return (Schema)getOrElse_this.get();
    }

    public byte[] keyToBytes(String transactionalId) {
        Struct key = new Struct(TransactionLog$KeySchema$.MODULE$.CURRENT());
        key.set(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD(), (Object)transactionalId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        Struct value = new Struct(TransactionLog$ValueSchema$.MODULE$.Current());
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()));
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField(), (Object)BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStatusField(), (Object)BoxesRunTime.boxToByte((byte)txnMetadata.txnState().byte()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnStartTimestamp()));
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null)) {
            if (txnMetadata.topicPartitions().nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(72).append("Transaction is not expected to have any partitions since its state is ").append(txnMetadata.txnState()).append(": ").append(txnMetadata).toString());
            }
            value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), null);
        } else {
            Iterable partitionArray = (Iterable)txnMetadata.topicPartitions().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var4_4;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topic = (String)x0$1._1();
                scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)x0$1._2();
                Struct topicPartitionsStruct = value.instance(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                Integer[] partitionIds = (Integer[])((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)topicPartition -> topicPartition.partition(), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField(), (Object)topic);
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField(), (Object)partitionIds);
                return var4_4;
            }, Iterable$.MODULE$.canBuildFrom());
            value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), partitionArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(TransactionLog$ValueSchema$.MODULE$.CurrentVersion());
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Struct key = this.kafka$coordinator$transaction$TransactionLog$$schemaForKey(version).read(buffer);
        if (version == TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION()) {
            String transactionalId = key.getString(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD());
            return new TxnKey(version, transactionalId);
        }
        throw new IllegalStateException(new StringBuilder(49).append("Unknown version ").append(version).append(" from the transaction log message").toString());
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        Struct value = this.kafka$coordinator$transaction$TransactionLog$$schemaForValue(version).read(buffer);
        if (version == TransactionLog$ValueSchema$.MODULE$.CurrentVersion()) {
            Long producerId = value.getLong(TransactionLog$ValueSchema$.MODULE$.ProducerIdField());
            Short epoch = value.getShort(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField());
            Integer timeout = value.getInt(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField());
            Byte stateByte = value.getByte(TransactionLog$ValueSchema$.MODULE$.TxnStatusField());
            TransactionState state = TransactionMetadata$.MODULE$.byteToState(Predef$.MODULE$.Byte2byte(stateByte));
            Long entryTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField());
            Long startTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField());
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, Predef$.MODULE$.Long2long(producerId), -1L, Predef$.MODULE$.Short2short(epoch), -1, Predef$.MODULE$.Integer2int(timeout), state, (scala.collection.mutable.Set<TopicPartition>)scala.collection.mutable.Set$.MODULE$.empty(), Predef$.MODULE$.Long2long(startTimestamp), Predef$.MODULE$.Long2long(entryTimestamp));
            if (!state.equals(Empty$.MODULE$)) {
                Object[] topicPartitionArray = value.getArray(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(topicPartitionArray));
                int foreach_len = foreach_this.length();
                for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                    Object object = foreach_this.apply(foreach_i);
                    TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata, object);
                }
            }
            return new Some((Object)transactionMetadata);
        }
        throw new IllegalStateException(new StringBuilder(55).append("Unknown version ").append(version).append(" from the transaction log message value").toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        String string;
        TxnKey txnKey = this.readTxnRecordKey(record.key());
        String keyString = new StringBuilder(38).append("transaction_metadata::transactionalId=").append(txnKey.transactionalId()).toString();
        Option<TransactionMetadata> option = this.readTxnRecordValue(txnKey.transactionalId(), record.value());
        if (None$.MODULE$.equals(option)) {
            string = "<DELETE>";
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            string = new StringBuilder(83).append("producerId:").append(txnMetadata.producerId()).append(",").append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").append("state=").append(txnMetadata.state()).append(",").append("partitions=").append(txnMetadata.topicPartitions().mkString("[", ",", "]")).append(",").append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString();
        } else {
            throw new MatchError(option);
        }
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)string));
    }

    public static final /* synthetic */ Nothing$ $anonfun$schemaForKey$1(int version$1) {
        throw new KafkaException(new StringBuilder(51).append("Unknown transaction log message key schema version ").append(version$1).toString());
    }

    public static final /* synthetic */ Nothing$ $anonfun$schemaForValue$1(int version$2) {
        throw new KafkaException(new StringBuilder(53).append("Unknown transaction log message value schema version ").append(version$2).toString());
    }

    public static final /* synthetic */ void $anonfun$readTxnRecordValue$1(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        Struct memberMetadata = (Struct)memberMetadataObj;
        String topic = memberMetadata.getString(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField());
        Object[] partitionIdArray = memberMetadata.getArray(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField());
        TopicPartition[] topicPartitions = (TopicPartition[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitionIdArray)), (Function1 & Serializable & scala.Serializable)partitionIdObj -> {
            Integer partitionId = (Integer)partitionIdObj;
            return new TopicPartition(topic, Predef$.MODULE$.Integer2int(partitionId));
        }, (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicPartition.class)));
        transactionMetadata$1.addPartitions((Set<TopicPartition>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartitions)).toSet());
    }

    private TransactionLog$() {
        MODULE$ = this;
        this.DefaultNumPartitions = 50;
        this.DefaultSegmentBytes = 0x6400000;
        this.DefaultReplicationFactor = (short)3;
        this.DefaultMinInSyncReplicas = 2;
        this.DefaultLoadBufferSize = 0x500000;
        this.EnforcedCompressionType = CompressionType.NONE;
        this.EnforcedRequiredAcks = (short)-1;
    }

    public static final /* synthetic */ Object $anonfun$readTxnRecordValue$1$adapted(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata$1, memberMetadataObj);
        return BoxedUnit.UNIT;
    }
}

