/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import org.apache.flume.Channel;
import org.apache.flume.Sink;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AbstractSink
implements Sink,
LifecycleAware {
    private Channel channel;
    private String name;
    private LifecycleState lifecycleState = LifecycleState.IDLE;

    @Override
    public synchronized void start() {
        Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"No channel configured");
        this.lifecycleState = LifecycleState.START;
    }

    @Override
    public synchronized void stop() {
        this.lifecycleState = LifecycleState.STOP;
    }

    @Override
    public synchronized Channel getChannel() {
        return this.channel;
    }

    @Override
    public synchronized void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public synchronized LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "{name:" + this.name + ", channel:" + this.channel.getName() + "}";
    }
}

