/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;

@ApiModel(value="Base info of stream sink")
public class BaseStreamSink {
    @ApiModelProperty(value="Enable data archiving")
    private Boolean enableDataArchiving;
    @ApiModelProperty(value="Transform sql")
    private String transformSql;
    @ApiModelProperty(value="Start consume time, yyyy-MM-dd HH:mm:ss format")
    private String startConsumeTime;
    @ApiModelProperty(value="Stop consume time, yyyy-MM-dd HH:mm:ss format")
    private String stopConsumeTime;

    public static BaseStreamSink getFromJson(@NotNull String extParams) {
        try {
            return (BaseStreamSink)JsonUtils.parseObject((String)extParams, BaseStreamSink.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public Boolean getEnableDataArchiving() {
        return this.enableDataArchiving;
    }

    public String getTransformSql() {
        return this.transformSql;
    }

    public String getStartConsumeTime() {
        return this.startConsumeTime;
    }

    public String getStopConsumeTime() {
        return this.stopConsumeTime;
    }

    public void setEnableDataArchiving(Boolean enableDataArchiving) {
        this.enableDataArchiving = enableDataArchiving;
    }

    public void setTransformSql(String transformSql) {
        this.transformSql = transformSql;
    }

    public void setStartConsumeTime(String startConsumeTime) {
        this.startConsumeTime = startConsumeTime;
    }

    public void setStopConsumeTime(String stopConsumeTime) {
        this.stopConsumeTime = stopConsumeTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseStreamSink)) {
            return false;
        }
        BaseStreamSink other = (BaseStreamSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableDataArchiving = this.getEnableDataArchiving();
        Boolean other$enableDataArchiving = other.getEnableDataArchiving();
        if (this$enableDataArchiving == null ? other$enableDataArchiving != null : !((Object)this$enableDataArchiving).equals(other$enableDataArchiving)) {
            return false;
        }
        String this$transformSql = this.getTransformSql();
        String other$transformSql = other.getTransformSql();
        if (this$transformSql == null ? other$transformSql != null : !this$transformSql.equals(other$transformSql)) {
            return false;
        }
        String this$startConsumeTime = this.getStartConsumeTime();
        String other$startConsumeTime = other.getStartConsumeTime();
        if (this$startConsumeTime == null ? other$startConsumeTime != null : !this$startConsumeTime.equals(other$startConsumeTime)) {
            return false;
        }
        String this$stopConsumeTime = this.getStopConsumeTime();
        String other$stopConsumeTime = other.getStopConsumeTime();
        return !(this$stopConsumeTime == null ? other$stopConsumeTime != null : !this$stopConsumeTime.equals(other$stopConsumeTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseStreamSink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableDataArchiving = this.getEnableDataArchiving();
        result = result * 59 + ($enableDataArchiving == null ? 43 : ((Object)$enableDataArchiving).hashCode());
        String $transformSql = this.getTransformSql();
        result = result * 59 + ($transformSql == null ? 43 : $transformSql.hashCode());
        String $startConsumeTime = this.getStartConsumeTime();
        result = result * 59 + ($startConsumeTime == null ? 43 : $startConsumeTime.hashCode());
        String $stopConsumeTime = this.getStopConsumeTime();
        result = result * 59 + ($stopConsumeTime == null ? 43 : $stopConsumeTime.hashCode());
        return result;
    }

    public String toString() {
        return "BaseStreamSink(enableDataArchiving=" + this.getEnableDataArchiving() + ", transformSql=" + this.getTransformSql() + ", startConsumeTime=" + this.getStartConsumeTime() + ", stopConsumeTime=" + this.getStopConsumeTime() + ")";
    }

    public BaseStreamSink(Boolean enableDataArchiving, String transformSql, String startConsumeTime, String stopConsumeTime) {
        this.enableDataArchiving = enableDataArchiving;
        this.transformSql = transformSql;
        this.startConsumeTime = startConsumeTime;
        this.stopConsumeTime = stopConsumeTime;
    }

    public BaseStreamSink() {
    }
}

