/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.expr.SQLTypeExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public final class SQLBooleanExpr
extends SQLTypeExpr {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("BOOLEAN");
    private boolean value;

    public SQLBooleanExpr() {
        super(new SQLDataTypeImpl("BOOLEAN"));
    }

    public SQLBooleanExpr(boolean value) {
        this();
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.getValue();
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuilder buf) {
        buf.append(this.getValue() != false ? "true" : "false");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() != false ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLBooleanExpr other = (SQLBooleanExpr)obj;
        return this.value == other.value;
    }

    @Override
    public SQLBooleanExpr clone() {
        return new SQLBooleanExpr(this.getValue());
    }

    public List getChildren() {
        return Collections.emptyList();
    }

    public static enum Type {
        ON_OFF;

    }
}

