/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.lock;

import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.core.store.DistributedLockDO;
import org.apache.seata.core.store.DistributedLocker;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.SetParams;

@LoadLevel(name="redis", scope=Scope.SINGLETON)
public class RedisDistributedLocker
implements DistributedLocker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RedisDistributedLocker.class);
    private static final String SUCCESS = "OK";

    public boolean acquireLock(DistributedLockDO distributedLockDO) {
        boolean bl;
        block8: {
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                String result = jedis.set(distributedLockDO.getLockKey(), distributedLockDO.getLockValue(), SetParams.setParams().nx().px(distributedLockDO.getExpireTime().longValue()));
                bl = SUCCESS.equalsIgnoreCase(result);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.error("The {} acquired the {} distributed lock failed.", new Object[]{distributedLockDO.getLockValue(), distributedLockDO.getLockKey(), ex});
                    return false;
                }
            }
            jedis.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean releaseLock(DistributedLockDO distributedLockDO) {
        String lockKey = distributedLockDO.getLockKey();
        String lockValue = distributedLockDO.getLockValue();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            jedis.watch(new String[]{lockKey});
            if (lockValue.equals(jedis.get(lockKey))) {
                Transaction multi = jedis.multi();
                multi.del(lockKey);
                multi.exec();
                boolean bl2 = true;
                return bl2;
            }
            jedis.unwatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOGGER.error("The {} release the {} distributed lock failed.", new Object[]{lockValue, lockKey, ex});
            return false;
        }
    }
}

