/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.branch;

import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.raft.session.RaftSessionManager;

public class RemoveBranchSessionExecute
extends AbstractRaftMsgExecute {
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager((String)sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession(sessionSyncMsg.getBranchSession().getXid());
        if (globalSession != null) {
            BranchSession branchSession = globalSession.getBranch(sessionSyncMsg.getBranchSession().getBranchId().longValue());
            if (branchSession != null) {
                this.raftLockManager.localReleaseLock(branchSession);
                globalSession.remove(branchSession);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("removeBranch xid: {},branchId: {}", (Object)globalSession.getXid(), (Object)sessionSyncMsg.getBranchSession().getBranchId());
            }
        }
        return true;
    }
}

