/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.util.concurrent.ThreadPoolExecutor;

class MonitoredThreadPool {
    private final ThreadPoolExecutor pool;

    MonitoredThreadPool(ThreadPoolExecutor pool) {
        this.pool = pool;
    }

    @Monitor(name="activeCount", type=DataSourceType.GAUGE)
    int getActiveCount() {
        return this.pool.getActiveCount();
    }

    @Monitor(name="completedTaskCount", type=DataSourceType.COUNTER)
    long getCompletedTaskCount() {
        return this.pool.getCompletedTaskCount();
    }

    @Monitor(name="corePoolSize", type=DataSourceType.GAUGE)
    int getCorePoolSize() {
        return this.pool.getCorePoolSize();
    }

    @Monitor(name="maximumPoolSize", type=DataSourceType.GAUGE)
    int getMaximumPoolSize() {
        return this.pool.getMaximumPoolSize();
    }

    @Monitor(name="poolSize", type=DataSourceType.GAUGE)
    int getPoolSize() {
        return this.pool.getPoolSize();
    }

    @Monitor(name="queueSize", type=DataSourceType.GAUGE)
    int getQueueSize() {
        return this.pool.getQueue().size();
    }

    @Monitor(name="taskCount", type=DataSourceType.COUNTER)
    long getTaskCount() {
        return this.pool.getTaskCount();
    }
}

