/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import java.util.Objects;
import org.apache.fory.Fory;
import org.apache.fory.serializer.Serializer;

public class GraalvmSupport {
    public static final boolean IN_GRAALVM_NATIVE_IMAGE;
    private static final String GRAAL_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    private static final String GRAAL_IMAGE_BUILDTIME = "buildtime";
    private static final String GRAAL_IMAGE_RUNTIME = "runtime";

    public static boolean isGraalBuildtime() {
        return IN_GRAALVM_NATIVE_IMAGE && GRAAL_IMAGE_BUILDTIME.equals(System.getProperty(GRAAL_IMAGE_CODE_KEY));
    }

    public static boolean isGraalRuntime() {
        return IN_GRAALVM_NATIVE_IMAGE && GRAAL_IMAGE_RUNTIME.equals(System.getProperty(GRAAL_IMAGE_CODE_KEY));
    }

    static {
        String imageCode = System.getProperty(GRAAL_IMAGE_CODE_KEY);
        IN_GRAALVM_NATIVE_IMAGE = imageCode != null;
    }

    public static class GraalvmSerializerHolder
    extends Serializer {
        private final Class serializerClass;

        public GraalvmSerializerHolder(Fory fory, Class<?> type, Class<?> serializerClass) {
            super(fory, type);
            this.serializerClass = Objects.requireNonNull(serializerClass);
        }

        public Class<? extends Serializer> getSerializerClass() {
            return this.serializerClass;
        }
    }
}

