/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.collection.IdentityObjectIntMap;
import org.apache.fory.collection.LongMap;
import org.apache.fory.collection.MapEntry;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.collection.Tuple3;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.ArraySerializers;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.MetaSharedSerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.SerializationBinding;
import org.apache.fory.serializer.SerializationUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.Generics;
import org.apache.fory.util.Preconditions;

public final class NonexistentClassSerializers {
    public static Serializer getSerializer(Fory fory, String className, Class<?> cls) {
        if (cls.isArray()) {
            return new ArraySerializers.NonexistentArrayClassSerializer(fory, className, cls);
        }
        if (cls.isEnum()) {
            return new NonexistentEnumClassSerializer(fory);
        }
        if (fory.getConfig().isMetaShareEnabled()) {
            throw new IllegalStateException(String.format("Serializer of class %s should be set in ClassResolver#getMetaSharedClassInfo", className));
        }
        return new CompatibleSerializer(fory, cls);
    }

    public static final class NonexistentEnumClassSerializer
    extends Serializer {
        private final NonexistentClass.NonexistentEnum[] enumConstants;
        private final MetaStringResolver metaStringResolver;

        public NonexistentEnumClassSerializer(Fory fory) {
            super(fory, NonexistentClass.NonexistentEnum.class);
            this.metaStringResolver = fory.getMetaStringResolver();
            this.enumConstants = (NonexistentClass.NonexistentEnum[])NonexistentClass.NonexistentEnum.class.getEnumConstants();
        }

        public Object read(MemoryBuffer buffer) {
            if (this.fory.getConfig().serializeEnumByName()) {
                this.metaStringResolver.readMetaStringBytes(buffer);
                return NonexistentClass.NonexistentEnum.UNKNOWN;
            }
            int ordinal = buffer.readVarUint32Small7();
            if (ordinal >= this.enumConstants.length) {
                ordinal = this.enumConstants.length - 1;
            }
            return this.enumConstants[ordinal];
        }
    }

    public static final class NonexistentClassSerializer
    extends Serializer {
        private final ClassDef classDef;
        private final ClassInfoHolder classInfoHolder;
        private final LongMap<ClassFieldsInfo> fieldsInfoMap;
        private final SerializationBinding binding;

        public NonexistentClassSerializer(Fory fory, ClassDef classDef) {
            super(fory, NonexistentClass.NonexistentMetaShared.class);
            this.classDef = classDef;
            this.classInfoHolder = fory.getClassResolver().nilClassInfoHolder();
            this.fieldsInfoMap = new LongMap();
            this.binding = SerializationBinding.createBinding(fory);
            Preconditions.checkArgument(fory.getConfig().isMetaShareEnabled());
        }

        private void writeClassDef(MemoryBuffer buffer, NonexistentClass.NonexistentMetaShared value) {
            buffer.increaseWriterIndex(-2);
            MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
            IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
            int newId = classMap.size;
            int id = classMap.putOrGet((Class<?>)value.classDef.getId(), newId);
            if (id >= 0) {
                buffer.writeVarUint32(id << 1 | 1);
            } else {
                buffer.writeVarUint32(newId << 1 | 1);
                metaContext.writingClassDefs.add(value.classDef);
            }
        }

        public void write(MemoryBuffer buffer, Object v) {
            NonexistentClass.NonexistentMetaShared value = (NonexistentClass.NonexistentMetaShared)v;
            this.writeClassDef(buffer, value);
            ClassDef classDef = value.classDef;
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(classDef);
            Fory fory = this.fory;
            RefResolver refResolver = fory.getRefResolver();
            ClassResolver classResolver = fory.getClassResolver();
            if (fory.checkClassVersion()) {
                buffer.writeInt32(fieldsInfo.classVersionHash);
            }
            AbstractObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ClassInfo classInfo = fieldInfo.classInfo;
                if (classResolver.isPrimitive(fieldInfo.classId)) {
                    classInfo.getSerializer().write(buffer, fieldValue);
                    continue;
                }
                if (isFinal[i]) {
                    Serializer serializer = classInfo.getSerializer();
                    this.binding.writeRef(buffer, fieldValue, serializer);
                    continue;
                }
                this.binding.writeRef(buffer, fieldValue, classInfo);
            }
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                boolean nullable = fieldInfo.nullable;
                if (fieldInfo.trackingRef) {
                    this.binding.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                    continue;
                }
                this.binding.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder, nullable);
            }
            Generics generics = fory.getGenerics();
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = value.get(fieldInfo.qualifiedFieldName);
                ObjectSerializer.writeContainerFieldValue(this.binding, refResolver, classResolver, generics, fieldInfo, buffer, fieldValue);
            }
        }

        private ClassFieldsInfo getClassFieldsInfo(ClassDef classDef) {
            ClassFieldsInfo fieldsInfo = this.fieldsInfoMap.get(classDef.getId());
            TypeResolver resolver = SerializationUtils.getTypeResolver(this.fory);
            if (fieldsInfo == null) {
                Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(resolver, NonexistentClass.NonexistentSkip.class, classDef);
                DescriptorGrouper descriptorGrouper = this.fory.getClassResolver().createDescriptorGrouper(descriptors, false);
                Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> tuple = AbstractObjectSerializer.buildFieldInfos(this.fory, descriptorGrouper);
                descriptors = descriptorGrouper.getSortedDescriptors();
                int classVersionHash = 0;
                if (this.fory.checkClassVersion()) {
                    classVersionHash = ObjectSerializer.computeStructHash(this.fory, descriptors);
                }
                fieldsInfo = new ClassFieldsInfo((AbstractObjectSerializer.FinalTypeField[])((Tuple2)tuple.f0).f0, (boolean[])((Tuple2)tuple.f0).f1, (AbstractObjectSerializer.GenericTypeField[])tuple.f1, (AbstractObjectSerializer.GenericTypeField[])tuple.f2, classVersionHash);
                this.fieldsInfoMap.put(classDef.getId(), fieldsInfo);
            }
            return fieldsInfo;
        }

        public Object read(MemoryBuffer buffer) {
            NonexistentClass.NonexistentMetaShared obj = new NonexistentClass.NonexistentMetaShared(this.classDef);
            Fory fory = this.fory;
            RefResolver refResolver = fory.getRefResolver();
            ClassResolver classResolver = fory.getClassResolver();
            refResolver.reference(obj);
            ArrayList entries = new ArrayList();
            ClassFieldsInfo fieldsInfo = this.getClassFieldsInfo(this.classDef);
            AbstractObjectSerializer.FinalTypeField[] finalFields = fieldsInfo.finalFields;
            boolean[] isFinal = fieldsInfo.isFinal;
            for (int i = 0; i < finalFields.length; ++i) {
                AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
                Object fieldValue = fieldInfo.classInfo == null ? fory.readRef(buffer, this.classInfoHolder) : (classResolver.isPrimitive(fieldInfo.classId) ? fieldInfo.classInfo.getSerializer().read(buffer) : AbstractObjectSerializer.readFinalObjectFieldValue(this.binding, refResolver, classResolver, fieldInfo, isFinal[i], buffer));
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.otherFields) {
                Object fieldValue = AbstractObjectSerializer.readOtherFieldValue(this.binding, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            Generics generics = fory.getGenerics();
            for (AbstractObjectSerializer.GenericTypeField fieldInfo : fieldsInfo.containerFields) {
                Object fieldValue = AbstractObjectSerializer.readContainerFieldValue(this.binding, generics, fieldInfo, buffer);
                entries.add(new MapEntry<String, Object>(fieldInfo.qualifiedFieldName, fieldValue));
            }
            obj.setEntries(entries);
            return obj;
        }
    }

    private static final class ClassFieldsInfo {
        private final AbstractObjectSerializer.FinalTypeField[] finalFields;
        private final boolean[] isFinal;
        private final AbstractObjectSerializer.GenericTypeField[] otherFields;
        private final AbstractObjectSerializer.GenericTypeField[] containerFields;
        private final int classVersionHash;

        private ClassFieldsInfo(AbstractObjectSerializer.FinalTypeField[] finalFields, boolean[] isFinal, AbstractObjectSerializer.GenericTypeField[] otherFields, AbstractObjectSerializer.GenericTypeField[] containerFields, int classVersionHash) {
            this.finalFields = finalFields;
            this.isFinal = isFinal;
            this.otherFields = otherFields;
            this.containerFields = containerFields;
            this.classVersionHash = classVersionHash;
        }
    }
}

