/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.Expression;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.function.Functions;

public class ExpressionUtils {
    public static Expression.ListExpression list(Expression ... expressions) {
        return new Expression.ListExpression(expressions);
    }

    public static Expression newObjectArray(Expression ... expressions) {
        return new Expression.NewArray(TypeRef.of(Object[].class), expressions);
    }

    public static boolean isReturn(Expression expr) {
        if (expr instanceof Expression.ListExpression) {
            expr = ((Expression.ListExpression)expr).last();
        }
        return expr instanceof Expression.Return;
    }

    public static Expression ofInt(String name, int v) {
        return new Expression.Variable(name, Expression.Literal.ofInt(v));
    }

    public static Expression valueOf(TypeRef<?> type, Expression value) {
        return new Expression.StaticInvoke(TypeUtils.getRawType(type), "valueOf", type, false, value);
    }

    public static Expression.IsNull isNull(Expression target) {
        return new Expression.IsNull(target);
    }

    public static Expression notNull(Expression target) {
        return new Expression.Not(new Expression.IsNull(target));
    }

    public static Expression eqNull(Expression target) {
        Preconditions.checkArgument(!target.type().isPrimitive());
        return ExpressionUtils.eq(target, new Expression.Null(target.type()));
    }

    public static Expression neqNull(Expression target) {
        Preconditions.checkArgument(!target.type().isPrimitive());
        return ExpressionUtils.neq(target, new Expression.Null(target.type()));
    }

    public static Expression.LogicalAnd and(Expression left, Expression right, String name) {
        return new Expression.LogicalAnd(false, left, right);
    }

    public static Expression.LogicalAnd and(Expression left, Expression right) {
        return new Expression.LogicalAnd(true, left, right);
    }

    public static Expression or(Expression left, Expression right, Expression ... expressions) {
        Expression.Literal l;
        if (left instanceof Expression.Literal && !((Boolean)(l = (Expression.Literal)left).getValue()).booleanValue()) {
            if (expressions.length == 0) {
                return right;
            }
            Expression.LogicalOr logicalOr = new Expression.LogicalOr(right, expressions[0]);
            for (int i = 1; i < expressions.length; ++i) {
                logicalOr = new Expression.LogicalOr(logicalOr, expressions[i]);
            }
            return logicalOr;
        }
        Expression.LogicalOr logicalOr = new Expression.LogicalOr(left, right);
        for (Expression expression : expressions) {
            logicalOr = new Expression.LogicalOr(logicalOr, expression);
        }
        return logicalOr;
    }

    public static Expression.BitOr bitor(Expression left, Expression right) {
        return new Expression.BitOr(left, right);
    }

    public static Expression.BitAnd bitand(Expression left, Expression right, String name) {
        Expression.BitAnd bitAnd = new Expression.BitAnd(left, right);
        bitAnd.inline(false);
        return bitAnd;
    }

    public static Expression.BitAnd bitand(Expression left, Expression right) {
        return new Expression.BitAnd(left, right);
    }

    public static Expression not(Expression target) {
        if (target instanceof Expression.Literal) {
            Expression.Literal literal = (Expression.Literal)target;
            Boolean b = (Boolean)literal.getValue();
            return Expression.Literal.ofBoolean(b == false);
        }
        return new Expression.Not(target);
    }

    public static Expression.Literal nullValue(TypeRef<?> type) {
        return new Expression.Literal(null, type);
    }

    public static Expression.Comparator eq(Expression left, Expression right) {
        return ExpressionUtils.eq(left, right, true);
    }

    public static Expression.Comparator eq(Expression left, Expression right, boolean inline) {
        return new Expression.Comparator("==", left, right, inline);
    }

    public static Expression.Comparator eq(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator("==", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator neq(Expression left, Expression right) {
        return ExpressionUtils.neq(left, right, true);
    }

    public static Expression.Comparator neq(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator("!=", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator neq(Expression left, Expression right, boolean inline) {
        return new Expression.Comparator("!=", left, right, inline);
    }

    public static Expression.Comparator egt(Expression left, Expression right) {
        return new Expression.Comparator(">=", left, right, true);
    }

    public static Expression.Comparator egt(Expression left, Expression right, String valuePrefix) {
        Expression.Comparator comparator = new Expression.Comparator(">=", left, right, false);
        comparator.valuePrefix = valuePrefix;
        return comparator;
    }

    public static Expression.Comparator gt(Expression left, Expression right) {
        Expression.Comparator comparator = new Expression.Comparator(">", left, right, true);
        return comparator;
    }

    public static Expression.Comparator lessThan(Expression left, Expression right) {
        return new Expression.Comparator("<", left, right, true);
    }

    public static Expression.Arithmetic add(Expression left, Expression right) {
        return new Expression.Arithmetic(true, "+", left, right);
    }

    public static Expression.Arithmetic add(Expression left, Expression right, String valuePrefix) {
        Expression.Arithmetic arithmetic = new Expression.Arithmetic(true, "+", left, right);
        arithmetic.valuePrefix = valuePrefix;
        return arithmetic;
    }

    public static Expression.Arithmetic subtract(Expression left, Expression right) {
        return new Expression.Arithmetic(true, "-", left, right);
    }

    public static Expression.Arithmetic subtract(Expression left, Expression right, String valuePrefix) {
        Expression.Arithmetic arithmetic = new Expression.Arithmetic(false, "-", left, right);
        arithmetic.valuePrefix = valuePrefix;
        return arithmetic;
    }

    public static Expression.BitShift shift(String op, Expression target, int numBits) {
        return new Expression.BitShift(op, target, numBits);
    }

    public static Expression.BitShift leftShift(Expression target, int numBits) {
        return new Expression.BitShift("<<", target, numBits);
    }

    public static Expression.BitShift arithRightShift(Expression target, int numBits) {
        return new Expression.BitShift(">>", target, numBits);
    }

    public static Expression.BitShift logicalRightShift(Expression target, int numBits) {
        return new Expression.BitShift(">>", target, numBits);
    }

    public static Expression cast(Expression value, TypeRef<?> typeRef) {
        if (value.type().equals(typeRef) || value.type().isSubtypeOf(typeRef)) {
            return value;
        }
        return new Expression.Cast(value, typeRef);
    }

    public static Expression cast(Expression value, TypeRef<?> typeRef, String namePrefix) {
        return new Expression.Cast(value, typeRef, namePrefix);
    }

    public static Expression invokeInline(Expression targetObject, String functionName, TypeRef type) {
        return ExpressionUtils.inline(ExpressionUtils.invoke(targetObject, functionName, null, type));
    }

    public static Expression invoke(Expression targetObject, String functionName, String returnNamePrefix, TypeRef type) {
        Class<?> returnType;
        Class<Object> rawType = type.getRawType();
        if (!CodeGenerator.sourcePublicAccessible(rawType)) {
            rawType = CodeGenerator.getSourcePublicAccessibleParentClass(rawType);
            type = type.getSupertype(rawType);
        }
        if (!rawType.isAssignableFrom(returnType = ReflectionUtils.getReturnType(TypeUtils.getRawType(targetObject.type()), functionName))) {
            if (!CodeGenerator.sourcePublicAccessible(returnType)) {
                returnType = CodeGenerator.getSourcePublicAccessibleParentClass(returnType);
            }
            return new Expression.Cast(new Expression.Invoke(targetObject, functionName, TypeRef.of(returnType)).inline(), type, returnNamePrefix);
        }
        return new Expression.Invoke(targetObject, functionName, returnNamePrefix, type);
    }

    public static Expression inline(Expression expression) {
        return ExpressionUtils.inline(expression, true);
    }

    private static Expression inline(Expression expression, boolean inline) {
        if (expression instanceof Expression.Inlineable) {
            ((Expression.Inlineable)expression).inline(inline);
        }
        return expression;
    }

    public static Expression uninline(Expression expression) {
        return ExpressionUtils.inline(expression, false);
    }

    public static Expression.StaticInvoke invokeStaticInline(Class<?> staticObject, String functionName, TypeRef<?> type, Expression ... arguments) {
        return new Expression.StaticInvoke(staticObject, functionName, "", type, false, true, arguments);
    }

    static String callFunc(String type, String resultVal, String target, String functionName, String args, boolean needTryCatch) {
        if (needTryCatch) {
            return StringUtils.format("${type} ${value};\ntry {\n   ${value} = ${target}.${functionName}(${args});\n} catch (Exception e) {\n   throw new RuntimeException(e);\n}", "type", type, "value", resultVal, "target", target, "functionName", functionName, "args", args);
        }
        return StringUtils.format("${type} ${value} = ${target}.${functionName}(${args});", "type", type, "value", resultVal, "target", target, "functionName", functionName, "args", args);
    }

    static String callFunc(String target, String functionName, String args, boolean needTryCatch) {
        if (needTryCatch) {
            return StringUtils.format("try {\n   ${target}.${functionName}(${args});\n} catch (Exception e) {\n   throw new RuntimeException(e);\n}", "target", target, "functionName", functionName, "args", args);
        }
        return StringUtils.format("${target}.${functionName}(${args});", "target", target, "functionName", functionName, "args", args);
    }

    public static List<Expression> extractCapturedExpressions(Serializable closure) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Functions.extractCapturedVariables(closure, capturedArg -> {
            if (capturedArg instanceof Expression) {
                expressions.add((Expression)capturedArg);
            } else if (capturedArg instanceof Expression[]) {
                Collections.addAll(Arrays.asList((Expression[])capturedArg), new Expression[0]);
            }
            return false;
        });
        return expressions;
    }
}

