/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.chenlb.mmseg4j.ComplexSeg;
import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.MMSeg;
import com.chenlb.mmseg4j.MaxWordSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.SimpleSeg;
import com.chenlb.mmseg4j.Word;
import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class MMSeg4JAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"Simple", (Object)"Complex", (Object)"MaxWord");
    private static final Dictionary DIC = Dictionary.getInstance();
    private Seg seg;

    public MMSeg4JAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for mmseg4j analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        int index = SUPPORT_MODES.indexOf(mode);
        switch (index) {
            case 0: {
                this.seg = new SimpleSeg(DIC);
                break;
            }
            case 1: {
                this.seg = new ComplexSeg(DIC);
                break;
            }
            case 2: {
                this.seg = new MaxWordSeg(DIC);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported segment mode '%s'", this.seg));
            }
        }
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        MMSeg mmSeg = new MMSeg((Reader)new StringReader(text), this.seg);
        try {
            Word word = null;
            while ((word = mmSeg.next()) != null) {
                result.add(word.getString());
            }
        }
        catch (Exception e) {
            throw new HugeException("MMSeg4j segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

