/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.hugegraph.store.node.metrics.GRpcExMetrics;
import org.apache.hugegraph.store.node.metrics.JRaftMetrics;
import org.apache.hugegraph.store.node.metrics.ProcfsMetrics;
import org.apache.hugegraph.store.node.metrics.RocksDBMetrics;
import org.apache.hugegraph.store.node.metrics.StoreMetrics;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricsConfig {
    @Bean
    public MeterRegistryCustomizer<MeterRegistry> metricsCommonTags() {
        return registry -> registry.config().commonTags(new String[]{"hg", "store"});
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> registerMeters() {
        return registry -> {
            StoreMetrics.init((MeterRegistry)registry);
            RocksDBMetrics.init((MeterRegistry)registry);
            JRaftMetrics.init((MeterRegistry)registry);
            ProcfsMetrics.init((MeterRegistry)registry);
            GRpcExMetrics.init((MeterRegistry)registry);
        };
    }
}

