/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeBelong;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/auth/belongs")
@Singleton
@Tag(name="BelongAPI")
public class BelongAPI
extends API {
    private static final Logger LOG = Log.logger(BelongAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, JsonBelong jsonBelong) {
        LOG.debug("GraphSpace [{}] create belong: {}", (Object)graphSpace, (Object)jsonBelong);
        BelongAPI.checkCreatingBody(jsonBelong);
        HugeBelong belong = jsonBelong.build();
        belong.id(manager.authManager().createBelong(belong));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)belong);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id, JsonBelong jsonBelong) {
        HugeBelong belong;
        LOG.debug("GraphSpace [{}] update belong: {}", (Object)graphSpace, (Object)jsonBelong);
        BelongAPI.checkUpdatingBody(jsonBelong);
        try {
            belong = manager.authManager().getBelong(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid belong id: " + id);
        }
        belong = jsonBelong.build(belong);
        manager.authManager().updateBelong(belong);
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)belong);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="user") String user, @QueryParam(value="group") String group, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        List belongs;
        LOG.debug("GraphSpace [{}] list belongs by user {} or group {}", new Object[]{graphSpace, user, group});
        E.checkArgument((user == null || group == null ? 1 : 0) != 0, (String)"Can't pass both user and group at the same time", (Object[])new Object[0]);
        if (user != null) {
            Id id = UserAPI.parseId(user);
            belongs = manager.authManager().listBelongByUser(id, limit);
        } else if (group != null) {
            Id id = UserAPI.parseId(group);
            belongs = manager.authManager().listBelongByGroup(id, limit);
        } else {
            belongs = manager.authManager().listAllBelong(limit);
        }
        return manager.serializer().writeAuthElements("belongs", belongs);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] get belong: {}", (Object)graphSpace, (Object)id);
        HugeBelong belong = manager.authManager().getBelong(UserAPI.parseId(id));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)belong);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] delete belong: {}", (Object)graphSpace, (Object)id);
        try {
            manager.authManager().deleteBelong(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid belong id: " + id);
        }
    }

    @JsonIgnoreProperties(value={"id", "belong_creator", "belong_create", "belong_update"})
    private static class JsonBelong
    implements Checkable {
        @JsonProperty(value="user")
        private String user;
        @JsonProperty(value="group")
        private String group;
        @JsonProperty(value="belong_description")
        private String description;

        private JsonBelong() {
        }

        public HugeBelong build(HugeBelong belong) {
            E.checkArgument((this.user == null || belong.source().equals(UserAPI.parseId(this.user)) ? 1 : 0) != 0, (String)"The user of belong can't be updated", (Object[])new Object[0]);
            E.checkArgument((this.group == null || belong.target().equals(UserAPI.parseId(this.group)) ? 1 : 0) != 0, (String)"The group of belong can't be updated", (Object[])new Object[0]);
            if (this.description != null) {
                belong.description(this.description);
            }
            return belong;
        }

        public HugeBelong build() {
            HugeBelong belong = new HugeBelong(UserAPI.parseId(this.user), UserAPI.parseId(this.group));
            belong.description(this.description);
            return belong;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.user, (String)"The user of belong can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.group, (String)"The group of belong can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.description, (String)"The description of belong can't be null", (Object[])new Object[0]);
        }
    }
}

