/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.pinyin;

import java.util.List;
import org.nlpcn.commons.lang.pinyin.PinyinFormat;
import org.nlpcn.commons.lang.pinyin.PinyinUtil;

public class Pinyin {
    public static List<String> pinyin(String str) {
        return PinyinUtil.INSTANCE.convert(str, PinyinFormat.TONELESS_PINYIN_FORMAT);
    }

    public static List<String> firstChar(String str) {
        return PinyinUtil.INSTANCE.convert(str, PinyinFormat.ABBR_PINYIN_FORMAT);
    }

    public static List<String> unicodePinyin(String str) {
        return PinyinUtil.INSTANCE.convert(str, PinyinFormat.UNICODE_PINYIN_FORMAT);
    }

    public static List<String> tonePinyin(String str) {
        return PinyinUtil.INSTANCE.convert(str, PinyinFormat.DEFAULT_PINYIN_FORMAT);
    }

    public static String list2String(List<String> list, String spearator) {
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        for (String string : list) {
            if (string == null) {
                string = "NULL";
            }
            if (flag) {
                sb.append(string);
                flag = false;
                continue;
            }
            sb.append(spearator);
            sb.append(string);
        }
        return sb.toString();
    }

    public static String list2String(List<String> list) {
        return Pinyin.list2String(list, " ");
    }

    public static void insertPinyin(String word, String[] pinyins) {
        PinyinUtil.INSTANCE.insertPinyin(word, pinyins);
    }

    public static String list2StringSkipNull(List<String> list) {
        return Pinyin.list2StringSkipNull(list, " ");
    }

    public static String list2StringSkipNull(List<String> list, String spearator) {
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        for (String string : list) {
            if (string == null) continue;
            if (flag) {
                sb.append(string);
                flag = false;
                continue;
            }
            sb.append(spearator);
            sb.append(string);
        }
        return sb.toString();
    }
}

