/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.codec.stacktrace;

import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.codec.stacktrace.ThreadTraceEvent;
import org.gridkit.jvmtool.event.CommonEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.GenericEvent;
import org.gridkit.jvmtool.event.TaggedEvent;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class ThreadSnapshotEventPojo
extends GenericEvent
implements ThreadSnapshotEvent {
    private long threadId = -1L;
    private String threadName;
    private Thread.State threadState;
    private StackFrameList stackTrace;

    @Override
    public long threadId() {
        return this.threadId;
    }

    public void threadId(long threadId) {
        this.threadId = threadId;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    public void threadName(String name) {
        this.threadName = name;
    }

    @Override
    public Thread.State threadState() {
        return this.threadState;
    }

    public void threadState(Thread.State state) {
        this.threadState = state;
    }

    @Override
    public StackFrameList stackTrace() {
        return this.stackTrace;
    }

    public void stackTrace(StackFrameList trace) {
        this.stackTrace = trace;
    }

    public void loadFrom(ThreadSnapshot event) {
        if (event instanceof ThreadSnapshotEvent) {
            this.loadFrom((ThreadSnapshotEvent)event);
        } else {
            this.timestamp(event.timestamp());
            this.threadId(event.threadId());
            this.threadName(event.threadName());
            this.threadState(event.threadState());
            this.counters().clear();
            this.counters().setAll(event.counters());
            this.stackTrace(event.stackTrace());
            if (event instanceof TaggedEvent) {
                this.tags().clear();
                this.tags().putAll(event.tags());
            }
        }
    }

    public void loadFrom(ThreadSnapshotEvent event) {
        this.copyCommonEventFrom(event);
        this.threadId(event.threadId());
        this.threadName(event.threadName());
        this.threadState(event.threadState());
        this.stackTrace(event.stackTrace());
    }

    public void loadFromRawEvent(Event event) {
        this.threadId(-1L);
        this.threadName(null);
        this.threadState(null);
        if (event instanceof CommonEvent) {
            CommonEvent cevent = (CommonEvent)event;
            this.copyCommonEventFrom(cevent);
            if (cevent.counters().getValue("thread.javaId") >= 0L) {
                this.threadId(cevent.counters().getValue("thread.javaId"));
            }
            this.threadName(cevent.tags().firstTagFor("thread.javaName"));
            this.threadState(this.state(cevent.tags().firstTagFor("thread.javaState")));
        }
        if (event instanceof ThreadTraceEvent) {
            this.stackTrace(((ThreadTraceEvent)event).stackTrace());
        }
    }

    private Thread.State state(String state) {
        try {
            return state == null ? null : Thread.State.valueOf(state);
        }
        catch (Exception e) {
            return null;
        }
    }
}

