/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.kubernetes.api.model.rbac.SubjectBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class K8sDriver {
    protected static final Logger LOG = Log.logger(K8sDriver.class);
    private static final String DELIMITER = "-";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String CONTAINER = "container";
    private static final String APP = "app";
    private static final String PORT_SUFFIX = "-port";
    private static final String TCP = "TCP";
    private static final String NODE_PORT = "NodePort";
    private static final int HG_PORT = 8080;
    private static final String CPU = "cpu";
    private static final String MEMORY = "memory";
    private static final String CPU_UNIT = "m";
    private static final String MEMORY_UNIT = "G";
    private static final String HEALTH_CHECK_API = "/versions";
    private static final String CA_CONFIG_MAP_NAME = "hg-ca";
    private static final String GRAPH_SPACE = "GRAPH_SPACE";
    private static final String SERVICE_ID = "SERVICE_ID";
    private static final String META_SERVERS = "META_SERVERS";
    private static final String CLUSTER = "CLUSTER";
    private static final String IMAGE_PULL_POLICY_ALWAYS = "Always";
    private static final String MY_NODE_NAME = "MY_NODE_NAME";
    private static final String MY_POD_IP = "MY_POD_IP";
    private static final String SPEC_NODE_NAME = "spec.nodeName";
    private static final String STATUS_POD_IP = "status.podIP";
    private static final String APP_NAME = "APP_NAME";
    private static final String SERVICE_ACCOUNT_NAME = "hugegraph-user";
    private static final String SERVICE_ACCOUNT = "ServiceAccount";
    private static final String BINDING_API_GROUP = "rbac.authorization.k8s.io";
    private static final String CLUSTER_ROLE = "ClusterRole";
    private static final String CLUSTER_ROLE_NAME = "cluster-admin";
    private static final String BINDING_API_VERSION = "rbac.authorization.k8s.io/v1";
    private final KubernetesClient client;
    private String oltpImage;
    private String olapImage;
    private String storageImage;
    private CA ca;

    public K8sDriver() {
        Config config = new ConfigBuilder().build();
        this.client = new DefaultKubernetesClient(config);
    }

    private static Set<String> urlsOfService(Service service, String routeType) {
        HashSet<String> urls = new HashSet<String>();
        String clusterIP = service.getSpec().getClusterIP();
        for (ServicePort port : service.getSpec().getPorts()) {
            int actualPort = routeType.equals(NODE_PORT) ? port.getNodePort() : port.getPort();
            urls.add(clusterIP + ":8080," + actualPort);
        }
        return urls;
    }

    private static String metaServers(List<String> metaServers) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < metaServers.size(); ++i) {
            builder.append(metaServers.get(i));
            if (i == metaServers.size() - 1) continue;
            builder.append(COMMA);
        }
        return builder.toString();
    }

    private static String namespace(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String namespace;
        switch (service.type()) {
            case OLTP: {
                namespace = graphSpace.oltpNamespace();
                break;
            }
            case OLAP: {
                namespace = graphSpace.olapNamespace();
                break;
            }
            case STORAGE: {
                namespace = graphSpace.storageNamespace();
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid service type '%s'", new Object[]{service.type()}));
            }
        }
        return namespace;
    }

    private static String validateNamespaceName(String namespace) {
        return namespace.replace("_", DELIMITER).toLowerCase();
    }

    private static String deploymentName(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        return K8sDriver.deploymentServiceName(graphSpace, service);
    }

    private static String serviceName(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        return K8sDriver.deploymentServiceName(graphSpace, service);
    }

    private static String deploymentServiceName(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String name = String.join((CharSequence)DELIMITER, graphSpace.name(), service.type().name(), service.name());
        return name.replace("_", DELIMITER).toLowerCase();
    }

    private static void sleepAWhile(int second) {
        try {
            Thread.sleep((long)second * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String serviceAccountName(String namespace) {
        return namespace + SERVICE_ACCOUNT_NAME;
    }

    public void ca(CA ca) {
        this.ca = ca;
    }

    public String oltpImage() {
        return this.oltpImage;
    }

    public void oltpImage(String oltpImage) {
        this.oltpImage = oltpImage;
    }

    public String olapImage() {
        return this.olapImage;
    }

    public void olapImage(String olapImage) {
        this.olapImage = olapImage;
    }

    public String storageImage() {
        return this.storageImage;
    }

    public void storageImage(String storageImage) {
        this.storageImage = storageImage;
    }

    public Namespace namespace(String ns) {
        NamespaceList nameSpaceList = (NamespaceList)this.client.namespaces().list();
        List namespaceList = nameSpaceList.getItems();
        for (Namespace namespace : namespaceList) {
            if (!namespace.getMetadata().getName().equals(ns)) continue;
            return namespace;
        }
        return null;
    }

    public List<Namespace> namespaces() {
        NamespaceList nameSpaceList = (NamespaceList)this.client.namespaces().list();
        return nameSpaceList.getItems();
    }

    public List<String> namespaceNames() {
        ArrayList<String> names = new ArrayList<String>();
        NamespaceList nameSpaceList = (NamespaceList)this.client.namespaces().list();
        for (Namespace namespace : nameSpaceList.getItems()) {
            names.add(namespace.getMetadata().getName());
        }
        return names;
    }

    public Namespace createNamespace(String name, Map<String, String> labels) {
        Namespace namespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(K8sDriver.validateNamespaceName(name))).addToLabels(labels)).endMetadata()).build();
        return (Namespace)this.client.namespaces().createOrReplace((Object[])new Namespace[]{namespace});
    }

    public boolean deleteNamespace(String name) {
        return ((Resource)this.client.namespaces().withName(name)).delete();
    }

    public Pod createPod(String namespace, String podName, Map<String, String> labels, String containerName, String image) {
        Pod pod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName)).addToLabels(labels)).endMetadata()).withNewSpec().addNewContainer().withName(containerName)).withImage(image)).endContainer()).endSpec()).build();
        return (Pod)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).createOrReplace((Object[])new Pod[]{pod});
    }

    public List<Pod> pods(String namespace) {
        return ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).list()).getItems();
    }

    public Pod pod(String namespace, String podName) {
        return (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podName)).get();
    }

    public Set<String> createOltpService(GraphSpace graphSpace, org.apache.hugegraph.space.Service service, List<String> metaServers, String cluster) {
        this.createConfigMapForCaIfNeeded(graphSpace, service);
        this.createServiceAccountIfNeeded(graphSpace, service);
        this.createDeployment(graphSpace, service, metaServers, cluster);
        return this.createService(graphSpace, service);
    }

    public Set<String> startOltpService(GraphSpace graphSpace, org.apache.hugegraph.space.Service service, List<String> metaServers, String cluster) {
        String namespace = K8sDriver.namespace(graphSpace, service);
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withName(CA_CONFIG_MAP_NAME)).get();
        if (null == configMap) {
            throw new HugeException("Cannot start OLTP service since configMap does not exist!");
        }
        ServiceAccount serviceAccount = (ServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(K8sDriver.serviceAccountName(namespace))).get();
        if (null == serviceAccount) {
            throw new HugeException("Cannot start OLTP service since service account is not created!");
        }
        String deploymentName = K8sDriver.deploymentName(graphSpace, service);
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        if (null == deployment) {
            throw new HugeException("Cannot start OLTP service since deployment is not created!");
        }
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).scale(service.count());
        return this.createService(graphSpace, service);
    }

    public void stopOltpService(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String serviceName = K8sDriver.serviceName(graphSpace, service);
        String namespace = K8sDriver.namespace(graphSpace, service);
        ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).delete();
        Service svc = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
        int count = 0;
        while (svc != null && count++ < 10) {
            svc = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
            K8sDriver.sleepAWhile(1);
        }
        if (svc != null) {
            throw new HugeException("Failed to stop service: %s", svc);
        }
        String deploymentName = K8sDriver.deploymentName(graphSpace, service);
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        if (null != deployment) {
            ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).scale(0);
        }
    }

    public void deleteOltpService(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String deploymentName = K8sDriver.serviceName(graphSpace, service);
        String namespace = K8sDriver.namespace(graphSpace, service);
        LOG.info("Stop deployment {} in namespace {}", (Object)deploymentName, (Object)namespace);
        ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).delete();
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        int count = 0;
        while (deployment != null && count++ < 10) {
            deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
            K8sDriver.sleepAWhile(1);
        }
        if (deployment != null) {
            throw new HugeException("Failed to stop deployment: %s", deployment);
        }
        LOG.info("Stop service {} in namespace {}", (Object)service, (Object)namespace);
        String serviceName = deploymentName;
        ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).delete();
        Service svc = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
        count = 0;
        while (svc != null && count++ < 10) {
            svc = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
            K8sDriver.sleepAWhile(1);
        }
        if (svc != null) {
            throw new HugeException("Failed to stop service: %s", svc);
        }
    }

    public void createConfigMapForCaIfNeeded(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String config;
        String clientKey;
        String clientCa;
        String ca;
        String namespace = K8sDriver.namespace(graphSpace, service);
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withName(CA_CONFIG_MAP_NAME)).get();
        if (configMap != null) {
            return;
        }
        try {
            ca = FileUtils.readFileToString((File)new File(this.ca.caFile));
            clientCa = FileUtils.readFileToString((File)new File(this.ca.clientCaFile));
            clientKey = FileUtils.readFileToString((File)new File(this.ca.clientKeyFile));
            config = FileUtils.readFileToString((File)new File(this.ca.config()));
        }
        catch (IOException e) {
            throw new HugeException("Failed to read ca files", e);
        }
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("config", config);
        data.put("ca.pem", ca);
        data.put("kubernetes.pem", clientCa);
        data.put("kubernetes-key8.pem", clientKey);
        ConfigMap cm = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(CA_CONFIG_MAP_NAME)).withNamespace(namespace)).endMetadata()).withData(data)).build();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).create((Object)cm);
    }

    private void createServiceAccountIfNeeded(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String namespace = K8sDriver.namespace(graphSpace, service);
        String serviceAccountName = K8sDriver.serviceAccountName(namespace);
        ServiceAccount serviceAccount = (ServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(serviceAccountName)).get();
        if (serviceAccount != null) {
            return;
        }
        serviceAccount = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(serviceAccountName)).withNamespace(namespace)).endMetadata()).build();
        ((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).create((Object)serviceAccount);
        Subject subject = ((SubjectBuilder)((SubjectBuilder)((SubjectBuilder)new SubjectBuilder().withKind(SERVICE_ACCOUNT)).withName(serviceAccountName)).withNamespace(namespace)).build();
        ClusterRoleBinding clusterRoleBinding = ((ClusterRoleBindingBuilder)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingFluent.RoleRefNested)((ClusterRoleBindingBuilder)((ClusterRoleBindingFluent.MetadataNested)((ClusterRoleBindingBuilder)new ClusterRoleBindingBuilder().withApiVersion(BINDING_API_VERSION)).withNewMetadata().withName(serviceAccountName)).endMetadata()).withNewRoleRef().withApiGroup(BINDING_API_GROUP)).withKind(CLUSTER_ROLE)).withName(CLUSTER_ROLE_NAME)).endRoleRef()).withSubjects(new Subject[]{subject})).build();
        this.client.rbac().clusterRoleBindings().create((Object)clusterRoleBinding);
    }

    public Set<String> createService(GraphSpace graphSpace, org.apache.hugegraph.space.Service svc) {
        String serviceName = K8sDriver.serviceName(graphSpace, svc);
        String namespace = K8sDriver.namespace(graphSpace, svc);
        String portName = serviceName + PORT_SUFFIX;
        Service service = NODE_PORT.equals(svc.routeType()) ? (svc.port() != 0 ? ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).endMetadata()).withNewSpec().withSelector(Collections.singletonMap(APP, serviceName))).addNewPort().withName(portName)).withProtocol(TCP)).withPort(Integer.valueOf(8080))).withTargetPort(new IntOrString(Integer.valueOf(8080)))).withNodePort(Integer.valueOf(svc.port()))).endPort()).withType(NODE_PORT)).endSpec()).build() : ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).endMetadata()).withNewSpec().withSelector(Collections.singletonMap(APP, serviceName))).addNewPort().withName(portName)).withProtocol(TCP)).withPort(Integer.valueOf(8080))).withTargetPort(new IntOrString(Integer.valueOf(8080)))).endPort()).withType(NODE_PORT)).endSpec()).build()) : ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).endMetadata()).withNewSpec().withSelector(Collections.singletonMap(APP, serviceName))).addNewPort().withName(portName)).withProtocol(TCP)).withPort(Integer.valueOf(8080))).withTargetPort(new IntOrString(Integer.valueOf(8080)))).endPort()).withType(svc.routeType())).endSpec()).build();
        LOG.info("Start service {} in namespace {}", (Object)service, (Object)namespace);
        ((NonNamespaceOperation)this.client.services().inNamespace(namespace)).create((Object)service);
        service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
        return K8sDriver.urlsOfService(service, svc.routeType());
    }

    public Deployment createDeployment(GraphSpace graphSpace, org.apache.hugegraph.space.Service service, List<String> metaServers, String cluster) {
        Deployment deployment = this.constructDeployment(graphSpace, service, metaServers, cluster);
        String namespace = K8sDriver.namespace(graphSpace, service);
        LOG.info("Start deployment {} in namespace {}", (Object)deployment, (Object)namespace);
        deployment = (Deployment)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).createOrReplace((Object[])new Deployment[]{deployment});
        ListOptions options = new ListOptions();
        options.setLabelSelector("app=" + K8sDriver.serviceName(graphSpace, service));
        List hugegraphservers = new ArrayList();
        int count = 0;
        while (hugegraphservers.isEmpty() && count++ < 10) {
            hugegraphservers = ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).list(options)).getItems();
            K8sDriver.sleepAWhile(1);
        }
        if (hugegraphservers.isEmpty()) {
            throw new HugeException("Failed to start oltp server pod");
        }
        return deployment;
    }

    private Deployment constructDeployment(GraphSpace graphSpace, org.apache.hugegraph.space.Service service, List<String> metaServers, String cluster) {
        String namespace = K8sDriver.namespace(graphSpace, service);
        String deploymentName = K8sDriver.deploymentName(graphSpace, service);
        String containerName = String.join((CharSequence)DELIMITER, deploymentName, CONTAINER);
        Quantity cpu = Quantity.parse((String)(service.cpuLimit() * 1000 + CPU_UNIT));
        Quantity memory = Quantity.parse((String)(service.memoryLimit() + MEMORY_UNIT));
        ResourceRequirements rr = ((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToLimits(CPU, cpu)).addToLimits(MEMORY, memory)).build();
        HTTPGetAction readyProbeAction = ((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(HEALTH_CHECK_API)).withPort(new IntOrString(Integer.valueOf(8080)))).build();
        ConfigMapVolumeSource cmvs = ((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(CA_CONFIG_MAP_NAME)).build();
        String metaServersString = K8sDriver.metaServers(metaServers);
        EnvVarSource nodeIP = ((EnvVarSourceBuilder)((EnvVarSourceFluent.FieldRefNested)new EnvVarSourceBuilder().withNewFieldRef().withFieldPath(SPEC_NODE_NAME)).endFieldRef()).build();
        EnvVarSource podIP = ((EnvVarSourceBuilder)((EnvVarSourceFluent.FieldRefNested)new EnvVarSourceBuilder().withNewFieldRef().withFieldPath(STATUS_POD_IP)).endFieldRef()).build();
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentName)).addToLabels(APP, deploymentName)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(service.count()))).withNewTemplate().withNewMetadata().addToLabels(APP, deploymentName)).endMetadata()).withNewSpec().withServiceAccountName(K8sDriver.serviceAccountName(namespace))).withAutomountServiceAccountToken(Boolean.valueOf(true))).addNewContainer().withName(containerName)).withImage(this.image(service))).withImagePullPolicy(IMAGE_PULL_POLICY_ALWAYS)).withResources(rr)).withNewReadinessProbe().withHttpGet(readyProbeAction)).withInitialDelaySeconds(Integer.valueOf(30))).withPeriodSeconds(Integer.valueOf(5))).endReadinessProbe()).addNewPort().withContainerPort(Integer.valueOf(8080))).endPort()).addNewVolumeMount().withName(CA_CONFIG_MAP_NAME)).withMountPath(CA_CONFIG_MAP_NAME)).endVolumeMount()).addNewEnv().withName(GRAPH_SPACE)).withValue(graphSpace.name())).endEnv()).addNewEnv().withName(SERVICE_ID)).withValue(service.name())).endEnv()).addNewEnv().withName(META_SERVERS)).withValue(metaServersString)).endEnv()).addNewEnv().withName(CLUSTER)).withValue(cluster)).endEnv()).addNewEnv().withName(MY_NODE_NAME)).withValueFrom(nodeIP)).endEnv()).addNewEnv().withName(MY_POD_IP)).withValueFrom(podIP)).endEnv()).addNewEnv().withName(APP_NAME)).withValue(deploymentName)).endEnv()).endContainer()).addNewVolume().withName(CA_CONFIG_MAP_NAME)).withConfigMap(cmvs)).endVolume()).endSpec()).endTemplate()).withNewSelector().addToMatchLabels(APP, deploymentName)).endSelector()).endSpec()).build();
    }

    private String image(org.apache.hugegraph.space.Service service) {
        switch (service.type()) {
            case OLTP: {
                return this.oltpImage;
            }
            case OLAP: {
                return this.olapImage;
            }
            case STORAGE: {
                return this.storageImage;
            }
        }
        throw new AssertionError((Object)String.format("Invalid service type '%s'", new Object[]{service.type()}));
    }

    public int podsRunning(GraphSpace graphSpace, org.apache.hugegraph.space.Service service) {
        String deploymentName = K8sDriver.deploymentName(graphSpace, service);
        String namespace = K8sDriver.namespace(graphSpace, service);
        try {
            Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
            if (null == deployment) {
                return 0;
            }
            DeploymentStatus status = deployment.getStatus();
            if (null == status) {
                return 0;
            }
            Integer replica = status.getAvailableReplicas();
            return Optional.ofNullable(replica).orElse(0);
        }
        catch (KubernetesClientException exc) {
            LOG.error("Get k8s deployment failed when check podsRunning", (Throwable)exc);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrReplaceByYaml(String yaml) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(yaml.getBytes());){
            ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable meta = this.client.load((InputStream)is);
            meta.createOrReplace();
        }
    }

    public void createOrReplaceResourceQuota(String namespace, String yaml) {
        ByteArrayInputStream is = new ByteArrayInputStream(yaml.getBytes());
        Resource quota = (Resource)((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(namespace)).load((InputStream)is);
        ((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(namespace)).createOrReplace((Object[])new ResourceQuota[]{(ResourceQuota)quota.get()});
    }

    public static class CA {
        private static final String CONFIG_PATH_SUFFIX = "/.kube/config";
        private static final String USER_HOME = "user.home";
        private final String caFile;
        private final String clientCaFile;
        private final String clientKeyFile;

        public CA(String caFile, String clientCaFile, String clientKeyFile) {
            E.checkArgument((caFile != null && !caFile.isEmpty() ? 1 : 0) != 0, (String)"The ca file can't be null or empty", (Object[])new Object[0]);
            E.checkArgument((clientCaFile != null && !clientCaFile.isEmpty() ? 1 : 0) != 0, (String)"The client ca file can't be null or empty", (Object[])new Object[0]);
            E.checkArgument((clientKeyFile != null && !clientKeyFile.isEmpty() ? 1 : 0) != 0, (String)"The client key file can't be null or empty", (Object[])new Object[0]);
            this.caFile = caFile;
            this.clientCaFile = clientCaFile;
            this.clientKeyFile = clientKeyFile;
        }

        public String caFile() {
            return this.caFile;
        }

        public String clientCaFile() {
            return this.clientCaFile;
        }

        public String clientKeyFile() {
            return this.clientKeyFile;
        }

        public String config() {
            return System.getProperty(USER_HOME) + CONFIG_PATH_SUFFIX;
        }
    }
}

